/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

class Complex {
    public double re;
    public double im;
    public double mag;
    public double phase;

    Complex() {
        this.phase = 0.0;
        this.mag = 0.0;
        this.im = 0.0;
        this.re = 0.0;
    }

    Complex(double r, double i) {
        this.set(r, i);
    }

    Complex(Complex c) {
        this.set(c.re, c.im);
    }

    double magSquared() {
        return this.mag * this.mag;
    }

    void set(double aa, double bb) {
        this.re = aa;
        this.im = bb;
        this.setMagPhase();
    }

    void set(double aa) {
        this.re = aa;
        this.im = 0.0;
        this.setMagPhase();
    }

    void set(Complex c) {
        this.re = c.re;
        this.im = c.im;
        this.mag = c.mag;
        this.phase = c.phase;
    }

    void add(double r) {
        this.re += r;
        this.setMagPhase();
    }

    void add(double r, double i) {
        this.re += r;
        this.im += i;
        this.setMagPhase();
    }

    void add(Complex c) {
        this.re += c.re;
        this.im += c.im;
        this.setMagPhase();
    }

    void addMult(double x, Complex z) {
        this.re += z.re * x;
        this.im += z.im * x;
        this.setMagPhase();
    }

    void square() {
        this.set(this.re * this.re - this.im * this.im, 2.0 * this.re * this.im);
    }

    void sqrt() {
        this.setMagPhase(Math.sqrt(this.mag), this.phase * 0.5);
    }

    void mult(double c, double d) {
        this.set(this.re * c - this.im * d, this.re * d + this.im * c);
    }

    void mult(double c) {
        this.re *= c;
        this.im *= c;
        this.mag *= c;
    }

    void mult(Complex c) {
        this.mult(c.re, c.im);
    }

    void setMagPhase() {
        this.mag = Math.sqrt(this.re * this.re + this.im * this.im);
        this.phase = Math.atan2(this.im, this.re);
    }

    void setMagPhase(double m, double ph) {
        this.mag = m;
        this.phase = ph;
        this.re = m * Math.cos(ph);
        this.im = m * Math.sin(ph);
    }

    void recip() {
        double n = this.re * this.re + this.im * this.im;
        this.set(this.re / n, -this.im / n);
    }

    void div(Complex c) {
        double n = c.re * c.re + c.im * c.im;
        this.mult(c.re / n, -c.im / n);
    }

    void rotate(double a) {
        this.setMagPhase(this.mag, (this.phase + a) % (Math.PI * 2));
    }

    void conjugate() {
        this.im = -this.im;
        this.phase = -this.phase;
    }

    void pow(double p) {
        this.phase *= p;
        double abs = Math.pow(this.re * this.re + this.im * this.im, p * 0.5);
        this.setMagPhase(abs, this.phase);
    }
}

