/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Random;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.SampleBuffer;
import org.corebounce.common.dsp.iir.ButterBandPass;
import org.corebounce.common.dsp.iir.ButterBandStop;
import org.corebounce.common.dsp.iir.ButterHighPass;
import org.corebounce.common.dsp.iir.ButterLowPass;
import org.corebounce.common.dsp.iir.ChebyBandPass;
import org.corebounce.common.dsp.iir.ChebyBandStop;
import org.corebounce.common.dsp.iir.ChebyHighPass;
import org.corebounce.common.dsp.iir.ChebyLowPass;
import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilter;
import org.corebounce.common.dsp.iir.DFilterCanvas;
import org.corebounce.common.dsp.iir.DFilterLayout;
import org.corebounce.common.dsp.iir.EllipticBandPass;
import org.corebounce.common.dsp.iir.EllipticBandStop;
import org.corebounce.common.dsp.iir.EllipticHighPass;
import org.corebounce.common.dsp.iir.EllipticLowPass;
import org.corebounce.common.dsp.iir.Filter;
import org.corebounce.common.dsp.iir.FilterType;
import org.corebounce.common.dsp.iir.IIRFilterType;
import org.corebounce.common.dsp.iir.InvChebyBandPass;
import org.corebounce.common.dsp.iir.InvChebyBandStop;
import org.corebounce.common.dsp.iir.InvChebyHighPass;
import org.corebounce.common.dsp.iir.InvChebyLowPass;
import org.corebounce.common.dsp.iir.NotchFilter;
import org.corebounce.common.dsp.iir.ResonatorFilter;
import org.corebounce.common.dsp.iir.ResonatorZeroFilter;

class DFilterFrame
extends Frame
implements ComponentListener,
ActionListener,
AdjustmentListener,
MouseMotionListener,
MouseListener,
ItemListener {
    Dimension winSize;
    Image dbimage;
    View respView;
    View impulseView;
    View phaseView;
    View stepView;
    View spectrumView;
    View waveformView;
    View poleInfoView;
    View polesView;
    Random random;
    int maxSampleCount = 70;
    int sampleCountR;
    int sampleCountTh;
    int modeCountR;
    int modeCountTh;
    int maxDispRModes = 5;
    int maxDispThModes = 5;
    public static final double epsilon = 1.0E-5;
    public static final double epsilon2 = 0.003;
    public static final double log10 = 2.302585092994046;
    public static int WINDOW_KAISER = 4;
    Checkbox soundCheck;
    Checkbox displayCheck;
    Checkbox shiftSpectrumCheck;
    CheckboxMenuItem freqCheckItem;
    CheckboxMenuItem phaseCheckItem;
    CheckboxMenuItem spectrumCheckItem;
    CheckboxMenuItem impulseCheckItem;
    CheckboxMenuItem stepCheckItem;
    CheckboxMenuItem waveformCheckItem;
    CheckboxMenuItem logFreqCheckItem;
    CheckboxMenuItem logAmpCheckItem;
    CheckboxMenuItem allWaveformCheckItem;
    CheckboxMenuItem ferrisCheckItem;
    MenuItem exitItem;
    Choice filterChooser;
    int selection;
    final int SELECT_RESPONSE = 1;
    final int SELECT_SPECTRUM = 2;
    final int SELECT_POLES = 3;
    int filterSelection;
    Choice inputChooser;
    Choice windowChooser;
    Choice rateChooser;
    Scrollbar[] auxBars;
    Label[] auxLabels;
    Label inputLabel;
    Scrollbar inputBar;
    Label shiftFreqLabel;
    Scrollbar shiftFreqBar;
    Label kaiserLabel;
    Scrollbar kaiserBar;
    boolean editingFunc;
    boolean dragStop;
    double inputW;
    static final double pi = Math.PI;
    double step;
    double waveGain = 1.52587890625E-5;
    double outputGain = 1.0;
    int sampleRate;
    int[] xpoints = new int[4];
    int[] ypoints = new int[4];
    int dragX;
    int dragY;
    int dragStartX;
    int dragStartY;
    int mouseX;
    int mouseY;
    int selectedPole;
    int selectedZero;
    int lastPoleCount = 2;
    int lastZeroCount = 2;
    boolean dragSet;
    boolean dragClear;
    boolean dragging;
    boolean unstable;
    MemoryImageSource imageSource;
    Image memimage;
    int[] pixels;
    double t;
    int pause;
    PlayThread playThread;
    Filter curFilter;
    FilterType filterType;
    double[] spectrumBuf;
    FFT spectrumFFT;
    Waveform wformInfo;
    PhaseColor[] phaseColors;
    static final int phaseColorCount = 400;
    boolean filterChanged;
    DFilterCanvas cv;
    DFilter applet;
    NumberFormat showFormat;
    boolean java2 = false;
    String[] mp3List;
    String mp3Error;
    long lastTime;
    double minlog;
    double logrange;
    double[] uresp;
    Complex[] customPoles;
    Complex[] customZeros;

    public String getAppletInfo() {
        return "DFilter Series by Paul Falstad";
    }

    int getrand(int x) {
        int q = this.random.nextInt();
        if (q < 0) {
            q = -q;
        }
        return q % x;
    }

    DFilterFrame(DFilter a) {
        super("Digital Filters Applet v1.2a");
        this.applet = a;
    }

    public void init() {
        this.mp3List = new String[20];
        try {
            String param = this.applet.getParameter("PAUSE");
            if (param != null) {
                this.pause = Integer.parseInt(param);
            }
            int i = 0;
            while (i < this.mp3List.length) {
                param = this.applet.getParameter("mp3File" + (i + 1));
                if (param != null) {
                    this.mp3List[i] = param;
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (Exception param) {
            // empty catch block
        }
        String jv = System.getProperty("java.class.version");
        double jvf = new Double(jv);
        if (jvf >= 48.0) {
            this.java2 = true;
        }
        int pc8 = 50;
        this.phaseColors = new PhaseColor[400];
        int i = 0;
        while (i != 8) {
            int j = 0;
            while (j != pc8) {
                double ang = Math.atan((double)j / (double)pc8);
                this.phaseColors[i * pc8 + j] = this.genPhaseColor(i, ang);
                ++j;
            }
            ++i;
        }
        this.customPoles = new Complex[20];
        this.customZeros = new Complex[20];
        i = 0;
        while (i != this.customPoles.length) {
            this.customPoles[i] = new Complex();
            ++i;
        }
        i = 0;
        while (i != this.customZeros.length) {
            this.customZeros[i] = new Complex();
            ++i;
        }
        this.setLayout(new DFilterLayout());
        this.cv = new DFilterCanvas(this);
        this.cv.addComponentListener(this);
        this.cv.addMouseMotionListener(this);
        this.cv.addMouseListener(this);
        this.add(this.cv);
        MenuBar mb = new MenuBar();
        Menu m = new Menu("File");
        mb.add(m);
        this.exitItem = this.getMenuItem("Exit");
        m.add(this.exitItem);
        m = new Menu("View");
        mb.add(m);
        this.freqCheckItem = this.getCheckItem("Frequency Response", true);
        m.add(this.freqCheckItem);
        this.phaseCheckItem = this.getCheckItem("Phase Response", false);
        m.add(this.phaseCheckItem);
        this.spectrumCheckItem = this.getCheckItem("Spectrum", true);
        m.add(this.spectrumCheckItem);
        this.waveformCheckItem = this.getCheckItem("Waveform", this.java2);
        m.add(this.waveformCheckItem);
        this.impulseCheckItem = this.getCheckItem("Impulse Response", true);
        m.add(this.impulseCheckItem);
        this.stepCheckItem = this.getCheckItem("Step Response", false);
        m.add(this.stepCheckItem);
        m.addSeparator();
        this.logFreqCheckItem = this.getCheckItem("Log Frequency Scale", false);
        m.add(this.logFreqCheckItem);
        this.allWaveformCheckItem = this.getCheckItem("Show Entire Waveform", false);
        m.add(this.allWaveformCheckItem);
        this.ferrisCheckItem = this.getCheckItem("Ferris Plot", false);
        m.add(this.ferrisCheckItem);
        this.logAmpCheckItem = this.getCheckItem("Log Amplitude Scale", true);
        this.setMenuBar(mb);
        this.soundCheck = new Checkbox("Sound On");
        if (this.java2) {
            this.soundCheck.setState(true);
        } else {
            this.soundCheck.setEnabled(false);
        }
        this.soundCheck.addItemListener(this);
        this.add(this.soundCheck);
        this.displayCheck = new Checkbox("Stop Display");
        this.displayCheck.addItemListener(this);
        this.add(this.displayCheck);
        this.shiftSpectrumCheck = new Checkbox("Shift Spectrum");
        this.shiftSpectrumCheck.addItemListener(this);
        this.add(this.shiftSpectrumCheck);
        this.inputChooser = new Choice();
        this.add(this.inputChooser);
        this.inputChooser.add("Input = Noise");
        this.inputChooser.add("Input = Sine Wave");
        this.inputChooser.add("Input = Sawtooth");
        this.inputChooser.add("Input = Triangle Wave");
        this.inputChooser.add("Input = Square Wave");
        this.inputChooser.add("Input = Periodic Noise");
        this.inputChooser.add("Input = Sweep");
        this.inputChooser.add("Input = Impulses");
        i = 0;
        while (this.mp3List[i] != null) {
            this.inputChooser.add("Input = " + this.mp3List[i]);
            ++i;
        }
        this.inputChooser.addItemListener(this);
        this.filterChooser = new Choice();
        this.add(this.filterChooser);
        this.filterChooser.add("Filter = FIR Low-pass");
        this.filterChooser.add("Filter = FIR High-pass");
        this.filterChooser.add("Filter = FIR Band-pass");
        this.filterChooser.add("Filter = FIR Band-stop");
        this.filterChooser.add("Filter = Custom FIR");
        this.filterChooser.add("Filter = None");
        this.filterChooser.add("Filter = Butterworth Low-pass");
        this.filterChooser.add("Filter = Butterworth High-pass");
        this.filterChooser.add("Filter = Butterworth Band-pass");
        this.filterChooser.add("Filter = Butterworth Band-stop");
        this.filterChooser.add("Filter = Chebyshev Low-pass");
        this.filterChooser.add("Filter = Chebyshev High-pass");
        this.filterChooser.add("Filter = Chebyshev Band-pass");
        this.filterChooser.add("Filter = Chebyshev Band-stop");
        this.filterChooser.add("Filter = Inv Cheby Low-pass");
        this.filterChooser.add("Filter = Inv Cheby High-pass");
        this.filterChooser.add("Filter = Inv Cheby Band-pass");
        this.filterChooser.add("Filter = Inv Cheby Band-stop");
        this.filterChooser.add("Filter = Elliptic Low-pass");
        this.filterChooser.add("Filter = Elliptic High-pass");
        this.filterChooser.add("Filter = Elliptic Band-pass");
        this.filterChooser.add("Filter = Elliptic Band-stop");
        this.filterChooser.add("Filter = Comb (+)");
        this.filterChooser.add("Filter = Comb (-)");
        this.filterChooser.add("Filter = Delay");
        this.filterChooser.add("Filter = Plucked String");
        this.filterChooser.add("Filter = Inverse Comb");
        this.filterChooser.add("Filter = Reson");
        this.filterChooser.add("Filter = Reson w/ Zeros");
        this.filterChooser.add("Filter = Notch");
        this.filterChooser.add("Filter = Moving Average");
        this.filterChooser.add("Filter = Triangle");
        this.filterChooser.add("Filter = Allpass");
        this.filterChooser.add("Filter = Gaussian");
        this.filterChooser.add("Filter = Random");
        this.filterChooser.add("Filter = Custom IIR");
        this.filterChooser.addItemListener(this);
        this.filterSelection = -1;
        this.windowChooser = new Choice();
        this.add(this.windowChooser);
        this.windowChooser.add("Window = Rectangular");
        this.windowChooser.add("Window = Hamming");
        this.windowChooser.add("Window = Hann");
        this.windowChooser.add("Window = Blackman");
        this.windowChooser.add("Window = Kaiser");
        this.windowChooser.add("Window = Bartlett");
        this.windowChooser.add("Window = Welch");
        this.windowChooser.addItemListener(this);
        this.windowChooser.select(1);
        this.rateChooser = new Choice();
        this.add(this.rateChooser);
        this.rateChooser.add("Sampling Rate = 8000");
        this.rateChooser.add("Sampling Rate = 11025");
        this.rateChooser.add("Sampling Rate = 16000");
        this.rateChooser.add("Sampling Rate = 22050");
        this.rateChooser.add("Sampling Rate = 32000");
        this.rateChooser.add("Sampling Rate = 44100");
        this.rateChooser.select(3);
        this.sampleRate = 22050;
        this.rateChooser.addItemListener(this);
        this.auxLabels = new Label[5];
        this.auxBars = new Scrollbar[5];
        i = 0;
        while (i != 5) {
            this.auxLabels[i] = new Label("", 1);
            this.add(this.auxLabels[i]);
            this.auxBars[i] = new Scrollbar(0, 25, 1, 1, 999);
            this.add(this.auxBars[i]);
            this.auxBars[i].addAdjustmentListener(this);
            ++i;
        }
        this.inputLabel = new Label("Input Frequency", 1);
        this.add(this.inputLabel);
        this.inputBar = new Scrollbar(0, 40, 1, 1, 999);
        this.add(this.inputBar);
        this.inputBar.addAdjustmentListener(this);
        this.shiftFreqLabel = new Label("Shift Frequency", 1);
        this.add(this.shiftFreqLabel);
        this.shiftFreqBar = new Scrollbar(0, 10, 1, 0, 1001);
        this.add(this.shiftFreqBar);
        this.shiftFreqBar.addAdjustmentListener(this);
        this.shiftFreqLabel.setVisible(false);
        this.shiftFreqBar.setVisible(false);
        this.kaiserLabel = new Label("Kaiser Parameter", 1);
        this.add(this.kaiserLabel);
        this.kaiserBar = new Scrollbar(0, 500, 1, 1, 999);
        this.add(this.kaiserBar);
        this.kaiserBar.addAdjustmentListener(this);
        this.random = new Random();
        this.setInputLabel();
        this.reinit();
        this.cv.setBackground(Color.black);
        this.cv.setForeground(Color.lightGray);
        this.showFormat = DecimalFormat.getInstance();
        this.showFormat.setMaximumFractionDigits(2);
        this.setSize(640, 640);
        this.handleResize();
        Dimension x = this.getSize();
        Dimension screen = this.getToolkit().getScreenSize();
        this.setLocation((screen.width - x.width) / 2, (screen.height - x.height) / 2);
        this.setVisible(true);
    }

    void reinit() {
        this.setupFilter();
        this.setInputW();
    }

    MenuItem getMenuItem(String s) {
        MenuItem mi = new MenuItem(s);
        mi.addActionListener(this);
        return mi;
    }

    CheckboxMenuItem getCheckItem(String s, boolean b) {
        CheckboxMenuItem mi = new CheckboxMenuItem(s);
        mi.setState(b);
        mi.addItemListener(this);
        return mi;
    }

    int getPower2(int n) {
        int o = 2;
        while (o < n) {
            o *= 2;
        }
        return o;
    }

    PhaseColor genPhaseColor(int sec, double ang) {
        ang += (double)sec * Math.PI / 4.0;
        int hsec = (int)(ang *= 0.954929658551372);
        double a2 = ang % 1.0;
        double a3 = 1.0 - a2;
        PhaseColor c = null;
        switch (hsec) {
            case 0: 
            case 6: {
                c = new PhaseColor(1.0, a2, 0.0);
                break;
            }
            case 1: {
                c = new PhaseColor(a3, 1.0, 0.0);
                break;
            }
            case 2: {
                c = new PhaseColor(0.0, 1.0, a2);
                break;
            }
            case 3: {
                c = new PhaseColor(0.0, a3, 1.0);
                break;
            }
            case 4: {
                c = new PhaseColor(a2, 0.0, 1.0);
                break;
            }
            case 5: {
                c = new PhaseColor(1.0, 0.0, a3);
            }
        }
        return c;
    }

    void handleResize() {
        Dimension d = this.winSize = this.cv.getSize();
        if (this.winSize.width == 0) {
            return;
        }
        int ct = 1;
        this.waveformView = null;
        this.stepView = null;
        this.phaseView = null;
        this.impulseView = null;
        this.spectrumView = null;
        this.respView = null;
        if (this.freqCheckItem.getState()) {
            ++ct;
        }
        if (this.phaseCheckItem.getState()) {
            ++ct;
        }
        if (this.spectrumCheckItem.getState()) {
            ++ct;
        }
        if (this.waveformCheckItem.getState()) {
            ++ct;
        }
        if (this.impulseCheckItem.getState()) {
            ++ct;
        }
        if (this.stepCheckItem.getState()) {
            ++ct;
        }
        this.dbimage = this.createImage(d.width, d.height);
        int i = 0;
        if (this.freqCheckItem.getState()) {
            this.respView = this.getView(i++, ct);
        }
        if (this.phaseCheckItem.getState()) {
            this.phaseView = this.getView(i++, ct);
        }
        if (this.spectrumCheckItem.getState()) {
            this.spectrumView = this.getView(i++, ct);
        }
        if (this.waveformCheckItem.getState()) {
            this.waveformView = this.getView(i++, ct);
        }
        if (this.impulseCheckItem.getState()) {
            this.impulseView = this.getView(i++, ct);
        }
        if (this.stepCheckItem.getState()) {
            this.stepView = this.getView(i++, ct);
        }
        this.poleInfoView = this.getView(i++, ct);
        if (this.poleInfoView.height > 200) {
            this.poleInfoView.height = 200;
        }
        this.polesView = new View(this.poleInfoView.x, this.poleInfoView.y, this.poleInfoView.height, this.poleInfoView.height);
        this.getPoleBuffer();
    }

    View getView(int i, int ct) {
        int dh3 = this.winSize.height / ct;
        int bd = 5;
        int tpad = 15;
        return new View(bd, bd + i * dh3 + tpad, this.winSize.width - bd * 2, dh3 - bd * 2 - tpad);
    }

    void getPoleBuffer() {
        this.pixels = null;
        if (this.java2) {
            try {
                Class<?> biclass = Class.forName("java.awt.image.BufferedImage");
                Class<?> dbiclass = Class.forName("java.awt.image.DataBufferInt");
                Class<?> rasclass = Class.forName("java.awt.image.Raster");
                Constructor<?> cstr = biclass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.memimage = (Image)cstr.newInstance(new Integer(this.polesView.width), new Integer(this.polesView.height), new Integer(1));
                Method m = biclass.getMethod("getRaster", new Class[0]);
                Object ras = m.invoke((Object)this.memimage, new Object[0]);
                Object db = rasclass.getMethod("getDataBuffer", new Class[0]).invoke(ras, new Object[0]);
                this.pixels = (int[])dbiclass.getMethod("getData", new Class[0]).invoke(db, new Object[0]);
            }
            catch (Exception ee) {
                System.out.println("BufferedImage failed");
            }
        }
        if (this.pixels == null) {
            this.pixels = new int[this.polesView.width * this.polesView.height];
            int i = 0;
            while (i != this.polesView.width * this.polesView.height) {
                this.pixels[i] = -16777216;
                ++i;
            }
            this.imageSource = new MemoryImageSource(this.polesView.width, this.polesView.height, this.pixels, 0, this.polesView.width);
            this.imageSource.setAnimated(true);
            this.imageSource.setFullBufferUpdates(true);
            this.memimage = this.cv.createImage(this.imageSource);
        }
    }

    void centerString(Graphics g, String s, int y) {
        FontMetrics fm = g.getFontMetrics();
        g.drawString(s, (this.winSize.width - fm.stringWidth(s)) / 2, y);
    }

    @Override
    public void paint(Graphics g) {
        this.cv.repaint();
    }

    public void updateDFilter(Graphics realg) {
        int x;
        double q;
        int k;
        int flen;
        int oy;
        int y;
        int i;
        Graphics g = this.dbimage.getGraphics();
        if (this.winSize == null || this.winSize.width == 0 || this.dbimage == null) {
            return;
        }
        if (this.curFilter == null) {
            Filter f;
            this.curFilter = f = this.filterType.genFilter();
            if (this.playThread != null) {
                this.playThread.setFilter(f);
            }
            this.filterChanged = true;
            this.unstable = false;
        }
        if (this.playThread == null && !this.unstable && this.soundCheck.getState()) {
            this.playThread = new PlayThread();
            this.playThread.start();
        }
        if (this.displayCheck.getState()) {
            return;
        }
        g.setColor(this.cv.getBackground());
        g.fillRect(0, 0, this.winSize.width, this.winSize.height);
        g.setColor(this.cv.getForeground());
        double minf = 40.0 / (double)this.sampleRate;
        this.minlog = Math.log(minf);
        this.logrange = Math.log(0.5) - this.minlog;
        Complex cc = new Complex();
        if (this.respView != null) {
            double q2;
            this.respView.drawLabel(g, "Frequency Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.respView.x, this.respView.y, this.respView.width, this.respView.height);
            g.setColor(Color.black);
            double ym = 0.069;
            i = 0;
            while (!((q2 = ym * (double)i) > 1.0)) {
                int y2 = this.respView.y + (int)(q2 * (double)this.respView.height);
                g.drawLine(this.respView.x, y2, this.respView.right, y2);
                i += 2;
            }
            i = 1;
            while (true) {
                double ll = this.logrange - (double)i * Math.log(2.0);
                int x2 = 0;
                x2 = this.logFreqCheckItem.getState() ? (int)(ll * (double)this.respView.width / this.logrange) : this.respView.width / (1 << i);
                if (x2 <= 0) break;
                g.drawLine(x2 += this.respView.x, this.respView.y, x2, this.respView.bottom);
                ++i;
            }
            g.setColor(Color.white);
            int ox = -1;
            int oy2 = -1;
            int ox2 = -1;
            int oy22 = -1;
            i = 0;
            while (i != this.respView.width) {
                double w = 0.0;
                if (!this.logFreqCheckItem.getState()) {
                    w = Math.PI * (double)i / (double)this.respView.width;
                } else {
                    double f = Math.exp(this.minlog + (double)i * this.logrange / (double)this.respView.width);
                    w = Math.PI * 2 * f;
                }
                this.filterType.getResponse(w, cc);
                double bw = cc.magSquared();
                double val = -ym * Math.log(bw * bw) / 2.302585092994046;
                int x3 = i + this.respView.x;
                if (val > 1.0) {
                    if (ox != -1) {
                        g.drawLine(ox, oy2, ox, this.respView.bottom);
                    }
                    ox = -1;
                } else {
                    int y3 = this.respView.y + (int)((double)this.respView.height * val);
                    if (ox != -1) {
                        g.drawLine(ox, oy2, x3, y3);
                    } else if (x3 > this.respView.x) {
                        g.drawLine(x3, this.respView.bottom, x3, y3);
                    }
                    ox = x3;
                    oy2 = y3;
                }
                if (this.filterType instanceof CustomFIRFilter) {
                    g.setColor(Color.white);
                    CustomFIRFilter cf = (CustomFIRFilter)this.filterType;
                    bw = cf.getUserResponse(w);
                    val = -ym * Math.log(bw * bw) / 2.302585092994046;
                    if (val > 1.0) {
                        if (ox2 != -1) {
                            g.drawLine(ox2, oy22, ox2, this.respView.bottom);
                        }
                        ox2 = -1;
                    } else {
                        y = this.respView.y + (int)((double)this.respView.height * val);
                        if (ox2 != -1) {
                            g.drawLine(ox2, oy22, x3, y);
                        } else if (x3 > this.respView.x) {
                            g.drawLine(x3, this.respView.bottom, x3, y);
                        }
                        ox2 = x3;
                        oy22 = y;
                    }
                    g.setColor(Color.red);
                }
                ++i;
            }
        }
        g.setColor(Color.white);
        if (this.phaseView != null) {
            this.phaseView.drawLabel(g, "Phase Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.phaseView.x, this.phaseView.y, this.phaseView.width, this.phaseView.height);
            g.setColor(Color.black);
            i = 0;
            while (i < 5) {
                double q3 = (double)i * 0.25;
                int y4 = this.phaseView.y + (int)(q3 * (double)this.phaseView.height);
                g.drawLine(this.phaseView.x, y4, this.phaseView.right, y4);
                ++i;
            }
            i = 1;
            while (true) {
                double ll = this.logrange - (double)i * Math.log(2.0);
                int x4 = 0;
                x4 = this.logFreqCheckItem.getState() ? (int)(ll * (double)this.phaseView.width / this.logrange) : this.phaseView.width / (1 << i);
                if (x4 <= 0) break;
                g.drawLine(x4 += this.phaseView.x, this.phaseView.y, x4, this.phaseView.bottom);
                ++i;
            }
            g.setColor(Color.white);
            int ox = -1;
            int oy3 = -1;
            i = 0;
            while (i != this.phaseView.width) {
                double w = 0.0;
                if (!this.logFreqCheckItem.getState()) {
                    w = Math.PI * (double)i / (double)this.phaseView.width;
                } else {
                    double f = Math.exp(this.minlog + (double)i * this.logrange / (double)this.phaseView.width);
                    w = Math.PI * 2 * f;
                }
                this.filterType.getResponse(w, cc);
                double val = 0.5 + cc.phase / (Math.PI * 2);
                int y5 = this.phaseView.y + (int)((double)this.phaseView.height * val);
                int x5 = i + this.phaseView.x;
                if (ox != -1) {
                    g.drawLine(ox, oy3, x5, y5);
                } else if (x5 > this.phaseView.x) {
                    g.drawLine(x5, this.phaseView.bottom, x5, y5);
                }
                ox = x5;
                oy3 = y5;
                ++i;
            }
        }
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        int infoX = 10;
        int ph = 0;
        int pw = 0;
        int cx = 0;
        int cy = 0;
        if (this.poleInfoView != null && (polect > 0 || zeroct > 0 || this.ferrisCheckItem.getState())) {
            Complex c1;
            pw = ph = this.polesView.height / 2;
            cx = this.polesView.x + pw;
            cy = this.polesView.y + ph;
            infoX = cx + pw + 10;
            if (!this.ferrisCheckItem.getState()) {
                int c1y;
                g.setColor(Color.white);
                FontMetrics fm = g.getFontMetrics();
                String s = "Poles/Zeros";
                g.drawString(s, cx - fm.stringWidth(s) / 2, this.polesView.y - 5);
                g.drawOval(cx - pw, cy - ph, pw * 2, ph * 2);
                g.drawLine(cx, cy - ph, cx, cy + ph);
                g.drawLine(cx - ph, cy, cx + ph, cy);
                c1 = new Complex();
                i = 0;
                while (i != polect) {
                    this.filterType.getPole(i, c1);
                    g.setColor(i == this.selectedPole ? Color.yellow : Color.white);
                    int c1x = cx + (int)((double)pw * c1.re);
                    c1y = cy - (int)((double)ph * c1.im);
                    g.drawLine(c1x - 3, c1y - 3, c1x + 3, c1y + 3);
                    g.drawLine(c1x - 3, c1y + 3, c1x + 3, c1y - 3);
                    ++i;
                }
                i = 0;
                while (i != zeroct) {
                    this.filterType.getZero(i, c1);
                    g.setColor(i == this.selectedZero ? Color.yellow : Color.white);
                    int c1x = cx + (int)((double)pw * c1.re);
                    c1y = cy - (int)((double)ph * c1.im);
                    g.drawOval(c1x - 3, c1y - 3, 6, 6);
                    ++i;
                }
                if (this.filterChanged) {
                    this.setCustomPolesZeros();
                }
            } else {
                if (this.filterChanged) {
                    c1 = new Complex();
                    int ri = 0;
                    while (ri != this.polesView.width) {
                        int ii = 0;
                        while (ii != this.polesView.height) {
                            c1.set((double)(ri - pw) / (double)pw, (double)(ii - pw) / (double)pw);
                            if (c1.re == 0.0 && c1.im == 0.0) {
                                c1.set(1.0E-30);
                            }
                            this.curFilter.evalTransfer(c1);
                            double cv = 0.0;
                            double wv = 0.0;
                            double m = Math.sqrt(c1.mag);
                            if (m < 1.0) {
                                cv = m;
                                wv = 1.0 - cv;
                            } else if (m < 2.0) {
                                cv = 2.0 - m;
                            }
                            cv *= 255.0;
                            wv *= 255.0;
                            double p = c1.phase;
                            if (p < 0.0) {
                                p += Math.PI * 2;
                            }
                            if (p >= Math.PI * 2) {
                                p -= Math.PI * 2;
                            }
                            PhaseColor pc = this.phaseColors[(int)(p * 400.0 / (Math.PI * 2))];
                            this.pixels[ri + ii * this.polesView.width] = -16777216 + 65536 * (int)(pc.r * cv + wv) + 256 * (int)(pc.g * cv + wv) + 1 * (int)(pc.b * cv + wv);
                            ++ii;
                        }
                        ++ri;
                    }
                }
                if (this.imageSource != null) {
                    this.imageSource.newPixels();
                }
                g.drawImage(this.memimage, this.polesView.x, this.polesView.y, null);
            }
        }
        if (this.poleInfoView != null) {
            double f;
            g.setColor(Color.white);
            String[] info = new String[10];
            this.filterType.getInfo(info);
            i = 0;
            while (i != 10) {
                if (info[i] == null) break;
                ++i;
            }
            if (this.wformInfo.needsFrequency()) {
                info[i++] = "Input Freq = " + (int)(this.inputW * (double)this.sampleRate / (Math.PI * 2));
            }
            info[i++] = "Output adjust = " + this.showFormat.format(-10.0 * Math.log(this.outputGain) / Math.log(0.1)) + " dB";
            i = 0;
            while (i != 10) {
                if (info[i] == null) break;
                g.drawString(info[i], infoX, this.poleInfoView.y + 5 + 20 * i);
                ++i;
            }
            if ((this.respView != null && this.respView.contains(this.mouseX, this.mouseY) || this.spectrumView != null && this.spectrumView.contains(this.mouseX, this.mouseY)) && (f = this.getFreqFromX(this.mouseX, this.respView)) >= 0.0) {
                double fw = Math.PI * 2 * f;
                g.setColor(Color.yellow);
                String s = "Selected Freq = " + (int)(f *= (double)this.sampleRate);
                if (this.respView.contains(this.mouseX, this.mouseY)) {
                    this.filterType.getResponse(fw, cc);
                    double bw = cc.magSquared();
                    bw = Math.log(bw * bw) / 4.605170185988092;
                    s = String.valueOf(s) + ", Response = " + this.showFormat.format(10.0 * bw) + " dB";
                }
                g.drawString(s, infoX, this.poleInfoView.y + 5 + 20 * i);
                if (ph > 0) {
                    int x6 = cx + (int)((double)pw * Math.cos(fw));
                    y = cy - (int)((double)pw * Math.sin(fw));
                    if (this.ferrisCheckItem.getState()) {
                        g.setColor(Color.black);
                        g.fillOval(x6 - 3, y - 3, 7, 7);
                    }
                    g.setColor(Color.yellow);
                    g.fillOval(x6 - 2, y - 2, 5, 5);
                }
            }
        }
        if (this.impulseView != null) {
            this.impulseView.drawLabel(g, "Impulse Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.impulseView.x, this.impulseView.y, this.impulseView.width, this.impulseView.height);
            g.setColor(Color.black);
            g.drawLine(this.impulseView.x, this.impulseView.y + this.impulseView.height / 2, this.impulseView.x + this.impulseView.width - 1, this.impulseView.y + this.impulseView.height / 2);
            g.setColor(Color.white);
            int offset = this.curFilter.getImpulseOffset();
            double[] impBuf = this.curFilter.getImpulseResponse(offset);
            int len = this.curFilter.getImpulseLen(offset, impBuf);
            int ox = -1;
            oy = -1;
            double mult = 0.5 / this.max(impBuf);
            int n = flen = len < 50 ? 50 : len;
            if (len < flen && flen < impBuf.length - offset) {
                len = flen;
            }
            i = 0;
            while (i != len) {
                k = offset + i;
                q = impBuf[k] * mult;
                int y6 = this.impulseView.y + (int)((double)this.impulseView.height * (0.5 - q));
                x = this.impulseView.x + this.impulseView.width * i / flen;
                if (len < 100) {
                    g.drawLine(x, this.impulseView.y + this.impulseView.height / 2, x, y6);
                    g.fillOval(x - 2, y6 - 2, 5, 5);
                } else {
                    if (ox != -1) {
                        g.drawLine(ox, oy, x, y6);
                    }
                    ox = x;
                    oy = y6;
                }
                ++i;
            }
        }
        if (this.stepView != null) {
            this.stepView.drawLabel(g, "Step Response");
            g.setColor(Color.darkGray);
            g.fillRect(this.stepView.x, this.stepView.y, this.stepView.width, this.stepView.height);
            g.setColor(Color.black);
            g.drawLine(this.stepView.x, this.stepView.y + this.stepView.height / 2, this.stepView.x + this.stepView.width - 1, this.stepView.y + this.stepView.height / 2);
            g.setColor(Color.white);
            int offset = this.curFilter.getStepOffset();
            double[] impBuf = this.curFilter.getStepResponse(offset);
            int len = this.curFilter.getStepLen(offset, impBuf);
            int ox = -1;
            oy = -1;
            double mult = 0.5 / this.max(impBuf);
            int n = flen = len < 50 ? 50 : len;
            if (len < flen && flen < impBuf.length - offset) {
                len = flen;
            }
            i = 0;
            while (i != len) {
                k = offset + i;
                q = impBuf[k] * mult;
                int y7 = this.stepView.y + (int)((double)this.stepView.height * (0.5 - q));
                x = this.stepView.x + this.stepView.width * i / flen;
                if (len < 100) {
                    g.drawLine(x, this.stepView.y + this.stepView.height / 2, x, y7);
                    g.fillOval(x - 2, y7 - 2, 5, 5);
                } else {
                    if (ox != -1) {
                        g.drawLine(ox, oy, x, y7);
                    }
                    ox = x;
                    oy = y7;
                }
                ++i;
            }
        }
        if (this.playThread != null) {
            int splen = this.playThread.spectrumLen;
            if (this.spectrumBuf == null || this.spectrumBuf.length != splen * 2) {
                this.spectrumBuf = new double[splen * 2];
            }
            int off = this.playThread.spectrumOffset;
            int mask = this.playThread.fbufmask;
            int i2 = 0;
            i = 0;
            while (i != splen) {
                int o = mask & off + i;
                this.spectrumBuf[i2] = this.playThread.fbufLo[o] + this.playThread.fbufRo[o];
                this.spectrumBuf[i2 + 1] = 0.0;
                ++i;
                i2 += 2;
            }
        } else {
            this.spectrumBuf = null;
        }
        if (this.waveformView != null && this.spectrumBuf != null) {
            this.waveformView.drawLabel(g, "Waveform");
            g.setColor(Color.darkGray);
            g.fillRect(this.waveformView.x, this.waveformView.y, this.waveformView.width, this.waveformView.height);
            g.setColor(Color.black);
            g.drawLine(this.waveformView.x, this.waveformView.y + this.waveformView.height / 2, this.waveformView.x + this.waveformView.width - 1, this.waveformView.y + this.waveformView.height / 2);
            g.setColor(Color.white);
            int ox = -1;
            int oy4 = -1;
            if (this.waveGain < 0.1) {
                this.waveGain = 0.1;
            }
            double max = 0.0;
            i = 0;
            while (i != this.spectrumBuf.length) {
                if (this.spectrumBuf[i] > max) {
                    max = this.spectrumBuf[i];
                }
                if (this.spectrumBuf[i] < -max) {
                    max = -this.spectrumBuf[i];
                }
                i += 2;
            }
            if (this.waveGain > 1.0 / max) {
                this.waveGain = 1.0 / max;
            } else if (this.waveGain * 1.05 < 1.0 / max) {
                this.waveGain *= 1.05;
            }
            double mult = 0.5 * this.waveGain;
            int nb = this.waveformView.width;
            if (nb > this.spectrumBuf.length || this.allWaveformCheckItem.getState()) {
                nb = this.spectrumBuf.length;
            }
            i = 0;
            while (i < nb) {
                double bf = 0.5 - this.spectrumBuf[i] * mult;
                int ya = (int)((double)this.waveformView.height * bf);
                if (ya > this.waveformView.height) {
                    ox = -1;
                } else {
                    int y8 = this.waveformView.y + ya;
                    int x7 = this.waveformView.x + i * this.waveformView.width / nb;
                    if (ox != -1) {
                        g.drawLine(ox, oy4, x7, y8);
                    }
                    ox = x7;
                    oy4 = y8;
                }
                i += 2;
            }
        }
        if (this.spectrumView != null && this.spectrumBuf != null) {
            double q4;
            this.spectrumView.drawLabel(g, "Spectrum");
            g.setColor(Color.darkGray);
            g.fillRect(this.spectrumView.x, this.spectrumView.y, this.spectrumView.width, this.spectrumView.height);
            g.setColor(Color.black);
            double ym = 0.138;
            i = 0;
            while (!((q4 = ym * (double)i) > 1.0)) {
                int y9 = this.spectrumView.y + (int)(q4 * (double)this.spectrumView.height);
                g.drawLine(this.spectrumView.x, y9, this.spectrumView.x + this.spectrumView.width, y9);
                ++i;
            }
            i = 1;
            while (true) {
                double ll = this.logrange - (double)i * Math.log(2.0);
                int x8 = 0;
                x8 = this.logFreqCheckItem.getState() ? (int)(ll * (double)this.spectrumView.width / this.logrange) : this.spectrumView.width / (1 << i);
                if (x8 <= 0) break;
                g.drawLine(x8 += this.spectrumView.x, this.spectrumView.y, x8, this.spectrumView.bottom);
                ++i;
            }
            g.setColor(Color.white);
            double cosmult = Math.PI * 2 / (double)(this.spectrumBuf.length - 2);
            i = 0;
            while (i != this.spectrumBuf.length) {
                double ht = 0.54 - 0.46 * Math.cos((double)i * cosmult);
                int n = i;
                this.spectrumBuf[n] = this.spectrumBuf[n] * ht;
                i += 2;
            }
            if (this.spectrumFFT == null || this.spectrumFFT.size != this.spectrumBuf.length / 2) {
                this.spectrumFFT = new FFT(this.spectrumBuf.length / 2);
            }
            this.spectrumFFT.transform(this.spectrumBuf, false);
            double bufmult = 1.0 / (double)(this.spectrumBuf.length / 2);
            bufmult = this.logAmpCheckItem.getState() ? (bufmult /= 65536.0) : (bufmult /= 768.0);
            bufmult *= bufmult;
            double[] specArray = new double[this.spectrumView.width];
            if (this.logFreqCheckItem.getState()) {
                i = 0;
                while (i != this.spectrumBuf.length / 2) {
                    double f = (double)i / (double)this.spectrumBuf.length;
                    int ix = (int)((double)specArray.length * (Math.log(f) - this.minlog) / this.logrange);
                    if (ix >= 0) {
                        int n = ix;
                        specArray[n] = specArray[n] + (this.spectrumBuf[i] * this.spectrumBuf[i] + this.spectrumBuf[i + 1] * this.spectrumBuf[i + 1]);
                    }
                    i += 2;
                }
            } else {
                i = 0;
                while (i != this.spectrumBuf.length / 2) {
                    int ix;
                    int n = ix = specArray.length * i * 2 / this.spectrumBuf.length;
                    specArray[n] = specArray[n] + (this.spectrumBuf[i] * this.spectrumBuf[i] + this.spectrumBuf[i + 1] * this.spectrumBuf[i + 1]);
                    i += 2;
                }
            }
            int maxi = specArray.length;
            i = 0;
            while (i != this.spectrumView.width) {
                double bf = specArray[i] * bufmult;
                bf = this.logAmpCheckItem.getState() ? -ym * Math.log(bf) / 2.302585092994046 : 1.0 - bf;
                int ya = (int)((double)this.spectrumView.height * bf);
                if (ya <= this.spectrumView.height) {
                    int y10 = this.spectrumView.y + ya;
                    x = this.spectrumView.x + i * this.spectrumView.width / maxi;
                    g.drawLine(x, y10, x, this.spectrumView.y + this.spectrumView.height - 1);
                }
                ++i;
            }
        }
        if (this.spectrumView != null && !this.java2) {
            g.setColor(Color.white);
            this.centerString(g, "Need java 2 for sound", this.spectrumView.y + this.spectrumView.height / 2);
        }
        if (this.unstable) {
            g.setColor(Color.red);
            this.centerString(g, "Filter is unstable", this.winSize.height / 2);
        }
        if (this.mp3Error != null) {
            g.setColor(Color.red);
            this.centerString(g, this.mp3Error, this.winSize.height / 2 + 20);
        }
        if (this.respView != null && this.respView.contains(this.mouseX, this.mouseY)) {
            g.setColor(Color.yellow);
            g.drawLine(this.mouseX, this.respView.y, this.mouseX, this.respView.y + this.respView.height - 1);
        }
        if (this.spectrumView != null && this.spectrumView.contains(this.mouseX, this.mouseY)) {
            g.setColor(Color.yellow);
            g.drawLine(this.mouseX, this.spectrumView.y, this.mouseX, this.spectrumView.y + this.spectrumView.height - 1);
        }
        this.filterChanged = false;
        realg.drawImage(this.dbimage, 0, 0, this);
    }

    void setCutoff(double f) {
    }

    void setCustomPolesZeros() {
        if (this.filterType instanceof CustomIIRFilter) {
            return;
        }
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        Complex c1 = new Complex();
        int n = 0;
        int i = 0;
        while (i != polect) {
            this.filterType.getPole(i, c1);
            if (c1.im >= 0.0) {
                this.customPoles[n++].set(c1);
                this.customPoles[n++].set(c1.re, -c1.im);
                if (n == this.customPoles.length) break;
            }
            ++i;
        }
        this.lastPoleCount = n;
        n = 0;
        i = 0;
        while (i != zeroct) {
            this.filterType.getZero(i, c1);
            if (c1.im >= 0.0) {
                this.customZeros[n++].set(c1);
                this.customZeros[n++].set(c1.re, -c1.im);
                if (n == this.customZeros.length) break;
            }
            ++i;
        }
        this.lastZeroCount = n;
    }

    int countPoints(double[] buf, int offset) {
        int len = buf.length;
        double max = 0.0;
        int result = 0;
        double last = 123.0;
        int i = offset;
        while (i < len) {
            double qa = Math.abs(buf[i]);
            if (qa > max) {
                max = qa;
            }
            if (Math.abs(qa - last) > max * 0.003) {
                result = i - offset + 1;
            }
            last = qa;
            ++i;
        }
        return result;
    }

    double max(double[] buf) {
        double max = 0.0;
        int i = 0;
        while (i != buf.length) {
            double qa = Math.abs(buf[i]);
            if (qa > max) {
                max = qa;
            }
            ++i;
        }
        return max;
    }

    double getFreqFromX(int x, View v) {
        double f = 0.5 * (double)(x - v.x) / (double)v.width;
        if (f <= 0.0 || f >= 0.5) {
            return -1.0;
        }
        if (this.logFreqCheckItem.getState()) {
            return Math.exp(this.minlog + 2.0 * f * this.logrange);
        }
        return f;
    }

    void setupFilter() {
        int filt = this.filterChooser.getSelectedIndex();
        switch (filt) {
            case 0: {
                this.filterType = new SincLowPassFilter();
                break;
            }
            case 1: {
                this.filterType = new SincHighPassFilter();
                break;
            }
            case 2: {
                this.filterType = new SincBandPassFilter();
                break;
            }
            case 3: {
                this.filterType = new SincBandStopFilter();
                break;
            }
            case 4: {
                this.filterType = new CustomFIRFilter();
                break;
            }
            case 5: {
                this.filterType = new NoFilter();
                break;
            }
            case 6: {
                this.filterType = new ButterLowPass(this);
                break;
            }
            case 7: {
                this.filterType = new ButterHighPass(this);
                break;
            }
            case 8: {
                this.filterType = new ButterBandPass(this);
                break;
            }
            case 9: {
                this.filterType = new ButterBandStop(this);
                break;
            }
            case 10: {
                this.filterType = new ChebyLowPass(this);
                break;
            }
            case 11: {
                this.filterType = new ChebyHighPass(this);
                break;
            }
            case 12: {
                this.filterType = new ChebyBandPass(this);
                break;
            }
            case 13: {
                this.filterType = new ChebyBandStop(this);
                break;
            }
            case 14: {
                this.filterType = new InvChebyLowPass(this);
                break;
            }
            case 15: {
                this.filterType = new InvChebyHighPass(this);
                break;
            }
            case 16: {
                this.filterType = new InvChebyBandPass(this);
                break;
            }
            case 17: {
                this.filterType = new InvChebyBandStop(this);
                break;
            }
            case 18: {
                this.filterType = new EllipticLowPass(this);
                break;
            }
            case 19: {
                this.filterType = new EllipticHighPass(this);
                break;
            }
            case 20: {
                this.filterType = new EllipticBandPass(this);
                break;
            }
            case 21: {
                this.filterType = new EllipticBandStop(this);
                break;
            }
            case 22: {
                this.filterType = new CombFilter(1);
                break;
            }
            case 23: {
                this.filterType = new CombFilter(-1);
                break;
            }
            case 25: {
                this.filterType = new PluckedStringFilter(this);
                break;
            }
            case 26: {
                this.filterType = new InverseCombFilter();
                break;
            }
            case 27: {
                this.filterType = new ResonatorFilter(this);
                break;
            }
            case 28: {
                this.filterType = new ResonatorZeroFilter(this);
                break;
            }
            case 29: {
                this.filterType = new NotchFilter(this);
                break;
            }
            case 30: {
                this.filterType = new MovingAverageFilter();
                break;
            }
            case 31: {
                this.filterType = new TriangleFilter();
                break;
            }
            case 32: {
                this.filterType = new AllPassFilter(this);
                break;
            }
            case 33: {
                this.filterType = new GaussianFilter();
                break;
            }
            case 34: {
                this.filterType = new RandomFilter();
                break;
            }
            case 35: {
                this.filterType = new CustomIIRFilter(this);
            }
        }
        if (this.filterSelection != filt) {
            this.filterSelection = filt;
            int i = 0;
            while (i != this.auxBars.length) {
                this.auxBars[i].setMaximum(999);
                ++i;
            }
            int ax = this.filterType.select();
            i = 0;
            while (i != ax) {
                this.auxLabels[i].setVisible(true);
                this.auxBars[i].setVisible(true);
                ++i;
            }
            i = ax;
            while (i != this.auxBars.length) {
                this.auxLabels[i].setVisible(false);
                this.auxBars[i].setVisible(false);
                ++i;
            }
            if (this.filterType.needsWindow()) {
                this.windowChooser.setVisible(true);
                this.setWindow();
            } else {
                this.windowChooser.setVisible(false);
                this.setWindow();
            }
            this.validate();
        }
        this.filterType.setup();
        this.curFilter = null;
    }

    void setInputLabel() {
        this.wformInfo = this.getWaveformObject();
        String inText = this.wformInfo.getInputText();
        if (inText == null) {
            this.inputLabel.setVisible(false);
            this.inputBar.setVisible(false);
        } else {
            this.inputLabel.setText(inText);
            this.inputLabel.setVisible(true);
            this.inputBar.setVisible(true);
        }
        this.validate();
    }

    Waveform getWaveformObject() {
        Waveform wform;
        int ic = this.inputChooser.getSelectedIndex();
        switch (ic) {
            case 0: {
                wform = new NoiseWaveform();
                break;
            }
            case 1: {
                wform = new SineWaveform();
                break;
            }
            case 2: {
                wform = new SawtoothWaveform();
                break;
            }
            case 3: {
                wform = new TriangleWaveform();
                break;
            }
            case 4: {
                wform = new SquareWaveform();
                break;
            }
            case 5: {
                wform = new PeriodicNoiseWaveform();
                break;
            }
            case 6: {
                wform = new SweepWaveform();
                break;
            }
            case 7: {
                wform = new ImpulseWaveform();
                break;
            }
            default: {
                wform = new Mp3Waveform(ic - 8);
            }
        }
        return wform;
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.cv.repaint(this.pause);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.handleResize();
        this.cv.repaint(this.pause);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.exitItem) {
            this.applet.destroyFrame();
            return;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.setupFilter();
        System.out.print(String.valueOf(((Scrollbar)e.getSource()).getValue()) + "\n");
        if (e.getSource() == this.inputBar) {
            this.setInputW();
        }
        this.cv.repaint(this.pause);
    }

    void setInputW() {
        this.inputW = Math.PI * (double)this.inputBar.getValue() / 1000.0;
    }

    @Override
    public boolean handleEvent(Event ev) {
        if (ev.id == 201) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.applet.destroyFrame();
            return true;
        }
        return super.handleEvent(ev);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseX = e.getX();
        this.mouseY = e.getY();
        this.edit(e);
        this.cv.repaint(this.pause);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.dragX = this.mouseX = e.getX();
        this.dragY = this.mouseY = e.getY();
        this.cv.repaint(this.pause);
        if (this.respView != null && this.respView.contains(e.getX(), e.getY())) {
            this.selection = 1;
        }
        if (this.spectrumView != null && this.spectrumView.contains(e.getX(), e.getY())) {
            this.selection = 2;
        }
        if (this.polesView != null && this.polesView.contains(e.getX(), e.getY()) && !this.ferrisCheckItem.getState()) {
            this.selection = 3;
            this.selectPoleZero(e.getX(), e.getY());
        }
    }

    void selectPoleZero(int x, int y) {
        int dist;
        int c1y;
        int c1x;
        int ph;
        this.selectedZero = -1;
        this.selectedPole = -1;
        int pw = ph = this.polesView.height / 2;
        int cx = this.polesView.x + pw;
        int cy = this.polesView.y + ph;
        Complex c1 = new Complex();
        int polect = this.filterType.getPoleCount();
        int zeroct = this.filterType.getZeroCount();
        int bestdist = 10000;
        int i = 0;
        while (i != polect) {
            this.filterType.getPole(i, c1);
            c1x = cx + (int)((double)pw * c1.re);
            c1y = cy - (int)((double)ph * c1.im);
            dist = this.distanceSq(c1x, c1y, x, y);
            if (dist <= bestdist) {
                bestdist = dist;
                this.selectedPole = i;
                this.selectedZero = -1;
            }
            ++i;
        }
        i = 0;
        while (i != zeroct) {
            this.filterType.getZero(i, c1);
            c1x = cx + (int)((double)pw * c1.re);
            c1y = cy - (int)((double)ph * c1.im);
            dist = this.distanceSq(c1x, c1y, x, y);
            if (dist < bestdist) {
                bestdist = dist;
                this.selectedPole = -1;
                this.selectedZero = i;
            }
            ++i;
        }
    }

    int distanceSq(int x1, int y1, int x2, int y2) {
        return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseMoved(e);
        this.edit(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    void edit(MouseEvent e) {
        double f;
        if (this.selection == 1) {
            if (this.filterType instanceof CustomFIRFilter) {
                this.editCustomFIRFilter(e);
                return;
            }
            f = this.getFreqFromX(e.getX(), this.respView);
            if (f < 0.0) {
                return;
            }
            this.filterType.setCutoff(f);
            this.setupFilter();
        }
        if (this.selection == 2) {
            if (!this.wformInfo.needsFrequency()) {
                return;
            }
            f = this.getFreqFromX(e.getX(), this.spectrumView);
            if (f < 0.0) {
                return;
            }
            this.inputW = Math.PI * 2 * f;
            this.inputBar.setValue((int)(2000.0 * f));
        }
        if (this.selection == 3 && this.filterType instanceof CustomIIRFilter) {
            this.editCustomIIRFilter(e);
            return;
        }
    }

    void editCustomFIRFilter(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.dragX == x) {
            this.editCustomFIRFilterPoint(x, y);
            this.dragY = y;
        } else {
            int x1 = x < this.dragX ? x : this.dragX;
            int y1 = x < this.dragX ? y : this.dragY;
            int x2 = x > this.dragX ? x : this.dragX;
            int y2 = x > this.dragX ? y : this.dragY;
            this.dragX = x;
            this.dragY = y;
            x = x1;
            while (x <= x2) {
                y = y1 + (y2 - y1) * (x - x1) / (x2 - x1);
                this.editCustomFIRFilterPoint(x, y);
                ++x;
            }
        }
        this.setupFilter();
    }

    void editCustomFIRFilterPoint(int x, int y) {
        double xx1 = this.getFreqFromX(x, this.respView) * 2.0;
        double xx2 = this.getFreqFromX(x + 1, this.respView) * 2.0;
        y -= this.respView.y;
        double ym = 0.069;
        double yy = Math.exp((double)(-y) * Math.log(10.0) / (ym * 4.0 * (double)this.respView.height));
        if (yy >= 1.0) {
            yy = 1.0;
        }
        ((CustomFIRFilter)this.filterType).edit(xx1, xx2, yy);
    }

    void editCustomIIRFilter(MouseEvent e) {
        int ph;
        if (this.ferrisCheckItem.getState()) {
            return;
        }
        int x = e.getX();
        int y = e.getY();
        int pw = ph = this.polesView.height / 2;
        int cx = this.polesView.x + pw;
        int cy = this.polesView.y + ph;
        Complex c1 = new Complex();
        c1.set((double)(x - cx) / (double)pw, (double)(y - cy) / (double)ph);
        ((CustomIIRFilter)this.filterType).editPoleZero(c1);
        this.setupFilter();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.filterChanged = true;
        if (e.getSource() == this.displayCheck) {
            this.cv.repaint(this.pause);
            return;
        }
        if (e.getSource() == this.inputChooser) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.setInputLabel();
        }
        if (e.getSource() == this.rateChooser) {
            if (this.playThread != null) {
                this.playThread.requestShutdown();
            }
            this.inputW *= (double)this.sampleRate;
            switch (this.rateChooser.getSelectedIndex()) {
                case 0: {
                    this.sampleRate = 8000;
                    break;
                }
                case 1: {
                    this.sampleRate = 11025;
                    break;
                }
                case 2: {
                    this.sampleRate = 16000;
                    break;
                }
                case 3: {
                    this.sampleRate = 22050;
                    break;
                }
                case 4: {
                    this.sampleRate = 32000;
                    break;
                }
                case 5: {
                    this.sampleRate = 44100;
                }
            }
            this.inputW /= (double)this.sampleRate;
        }
        if (e.getSource() == this.shiftSpectrumCheck) {
            if (this.shiftSpectrumCheck.getState()) {
                this.shiftFreqLabel.setVisible(true);
                this.shiftFreqBar.setVisible(true);
            } else {
                this.shiftFreqLabel.setVisible(false);
                this.shiftFreqBar.setVisible(false);
            }
            this.validate();
        }
        if (e.getSource() == this.windowChooser) {
            this.setWindow();
        }
        if (e.getSource() instanceof CheckboxMenuItem) {
            this.handleResize();
        } else {
            this.setupFilter();
        }
        this.cv.repaint(this.pause);
    }

    void setWindow() {
        if (this.windowChooser.getSelectedIndex() == WINDOW_KAISER && this.filterType.needsWindow()) {
            this.kaiserLabel.setVisible(true);
            this.kaiserBar.setVisible(true);
        } else {
            this.kaiserLabel.setVisible(false);
            this.kaiserBar.setVisible(false);
        }
        this.validate();
    }

    void setSampleRate(int r) {
        int x = 0;
        switch (r) {
            case 8000: {
                x = 0;
                break;
            }
            case 11025: {
                x = 1;
                break;
            }
            case 16000: {
                x = 2;
                break;
            }
            case 22050: {
                x = 3;
                break;
            }
            case 32000: {
                x = 4;
                break;
            }
            case 44100: {
                x = 5;
            }
        }
        this.rateChooser.select(x);
        this.sampleRate = r;
    }

    String getOmegaText(double wc) {
        return String.valueOf((int)(wc * (double)this.sampleRate / (Math.PI * 2))) + " Hz";
    }

    double cosh(double x) {
        return 0.5 * (Math.exp(x) + Math.exp(-x));
    }

    double sinh(double x) {
        return 0.5 * (Math.exp(x) - Math.exp(-x));
    }

    double acosh(double x) {
        return Math.log(x + Math.sqrt(x * x - 1.0));
    }

    String getUnitText(double v, String u) {
        double va = Math.abs(v);
        if (va < 1.0E-17) {
            return "0 " + u;
        }
        if (va < 1.0E-12) {
            return String.valueOf(this.showFormat.format(v * 1.0E15)) + " f" + u;
        }
        if (va < 1.0E-9) {
            return String.valueOf(this.showFormat.format(v * 1.0E12)) + " p" + u;
        }
        if (va < 1.0E-6) {
            return String.valueOf(this.showFormat.format(v * 1.0E9)) + " n" + u;
        }
        if (va < 0.001) {
            return String.valueOf(this.showFormat.format(v * 1000000.0)) + " \u03bc" + u;
        }
        if (va < 0.01 || u.compareTo("m") != 0 && va < 1.0) {
            return String.valueOf(this.showFormat.format(v * 1000.0)) + " m" + u;
        }
        if (va < 1.0) {
            return String.valueOf(this.showFormat.format(v * 100.0)) + " c" + u;
        }
        if (va < 1000.0) {
            return String.valueOf(this.showFormat.format(v)) + " " + u;
        }
        if (va < 1000000.0) {
            return String.valueOf(this.showFormat.format(v * 0.001)) + " k" + u;
        }
        if (va < 1.0E9) {
            return String.valueOf(this.showFormat.format(v * 1.0E-6)) + " M" + u;
        }
        if (va < 1.0E12) {
            return String.valueOf(this.showFormat.format(v * 1.0E-9)) + " G" + u;
        }
        if (va < 1.0E15) {
            return String.valueOf(this.showFormat.format(v * 1.0E-12)) + " T" + u;
        }
        return String.valueOf(v) + " " + u;
    }

    double bessi0(double x) {
        double ans;
        double d;
        double ax = Math.abs(x);
        if (d < 3.75) {
            double y = x / 3.75;
            y *= y;
            ans = 1.0 + y * (3.5156229 + y * (3.0899424 + y * (1.2067492 + y * (0.2659732 + y * (0.0360768 + y * 0.0045813)))));
        } else {
            double y = 3.75 / ax;
            ans = Math.exp(ax) / Math.sqrt(ax) * (0.39894228 + y * (0.01328592 + y * (0.00225319 + y * (-0.00157565 + y * (0.00916281 + y * (-0.02057706 + y * (0.02635537 + y * (-0.01647633 + y * 0.00392377))))))));
        }
        return ans;
    }

    class AllPassFilter
    extends IIRFilterType {
        double a;

        AllPassFilter(DFilterFrame dFilterFrame2) {
            super(dFilterFrame2);
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Phase Delay");
            DFilterFrame.this.auxBars[0].setValue(500);
            return 1;
        }

        @Override
        void setup() {
            double delta = (double)DFilterFrame.this.auxBars[0].getValue() / 1000.0;
            this.a = (1.0 - delta) / (1.0 + delta);
        }

        @Override
        void getPole(int i, Complex c1) {
            c1.set(-this.a);
        }

        @Override
        int getPoleCount() {
            return 1;
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[2];
            f.bList = new double[2];
            int[] nArray = new int[2];
            nArray[1] = 1;
            f.nList = nArray;
            f.aList[0] = this.a;
            f.aList[1] = 1.0;
            f.bList[0] = 1.0;
            f.bList[1] = this.a;
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Allpass Fractional Delay (IIR)";
        }
    }

    class BoxFilter
    extends FIRFilterType {
        double cw;
        double r;
        double norm;
        int n;

        BoxFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Fundamental Freq");
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxLabels[1].setText("Position");
            DFilterFrame.this.auxBars[1].setValue(300);
            DFilterFrame.this.auxLabels[2].setText("Length/Width");
            DFilterFrame.this.auxBars[2].setValue(100);
            DFilterFrame.this.auxLabels[3].setText("Order");
            DFilterFrame.this.auxBars[3].setMaximum(1600);
            DFilterFrame.this.auxBars[3].setValue(100);
            return 4;
        }

        @Override
        void setCutoff(double f) {
        }

        @Override
        void setup() {
            this.cw = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            if (this.cw < 0.147) {
                this.cw = 0.147;
            }
            this.r = (double)DFilterFrame.this.auxBars[1].getValue() / 1000.0;
            this.n = DFilterFrame.this.auxBars[3].getValue();
        }

        @Override
        Filter genFilter() {
            int j;
            DirectFilter f = new DirectFilter();
            int nn = 20;
            double[][] ws = new double[nn][nn];
            double[][] mg = new double[nn][nn];
            double px = this.r * Math.PI;
            double py = 1.5707963267948966;
            double ly = (double)DFilterFrame.this.auxBars[2].getValue() / 100.0;
            int i = 0;
            while (i != nn) {
                j = 0;
                while (j != nn) {
                    ws[i][j] = this.cw * Math.sqrt((double)(i * i) + (double)(j * j) / ly);
                    mg[i][j] = Math.cos((double)i * px) * Math.cos((double)j * py);
                    ++j;
                }
                ++i;
            }
            mg[0][0] = 0.0;
            f.aList = new double[this.n];
            double sum = 0.0;
            double ecoef = -2.5 / (double)this.n;
            int k = 0;
            while (k != this.n) {
                double q = 0.0;
                i = 0;
                while (i != nn) {
                    j = 0;
                    while (j != nn) {
                        double ph = (double)k * ws[i][j];
                        q += mg[i][j] * Math.cos(ph);
                        ++j;
                    }
                    ++i;
                }
                f.aList[k] = q * Math.exp(ecoef * (double)k);
                sum += q;
                ++k;
            }
            i = 0;
            while (i != this.n) {
                int n = i++;
                f.aList[n] = f.aList[n] / sum;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Order: " + this.n;
        }
    }

    class CombFilter
    extends IIRFilterType {
        int n;
        int sign;
        double mult;
        double peak;

        CombFilter(int s) {
            super(DFilterFrame.this);
            this.sign = s;
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("1st Pole");
            DFilterFrame.this.auxBars[0].setValue(60);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(700);
            return 2;
        }

        @Override
        void setup() {
            this.n = 2000 / DFilterFrame.this.auxBars[0].getValue();
            this.mult = (double)DFilterFrame.this.auxBars[1].getValue() / 1000.0;
            this.peak = 1.0 / (1.0 - this.mult);
        }

        @Override
        void getPole(int i, Complex c1) {
            int odd = this.sign == 1 ? 0 : 1;
            c1.setMagPhase(Math.pow(this.mult, 1.0 / (double)this.n), Math.PI * (double)(odd + 2 * i) / (double)this.n);
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[]{1.0 / this.peak, 0.0};
            f.bList = new double[]{0.0, (double)(-this.sign) * this.mult};
            int[] nArray = new int[2];
            nArray[1] = this.n;
            f.nList = nArray;
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Comb (IIR); Resonance every " + DFilterFrame.this.getOmegaText(Math.PI * 2 / (double)this.n);
            x[1] = "Delay: " + this.n + " samples, " + DFilterFrame.this.getUnitText((double)this.n / (double)DFilterFrame.this.sampleRate, "s");
            double tl = 340.0 * (double)this.n / (double)(DFilterFrame.this.sampleRate * 2);
            x[2] = "Tube length: " + DFilterFrame.this.getUnitText(tl, "m");
            x[2] = this.sign == -1 ? String.valueOf(x[2]) + " (closed)" : String.valueOf(x[2]) + " (open)";
        }

        @Override
        int getPoleCount() {
            return this.n;
        }

        @Override
        int getZeroCount() {
            return this.n;
        }

        @Override
        void getZero(int i, Complex c1) {
            c1.set(0.0);
        }
    }

    class CustomFIRFilter
    extends FIRFilterType {
        CustomFIRFilter() {
            if (DFilterFrame.this.uresp == null) {
                DFilterFrame.this.uresp = new double[1024];
            }
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Order");
            DFilterFrame.this.auxBars[0].setValue(120);
            DFilterFrame.this.auxBars[0].setMaximum(1600);
            int i = 0;
            while (i != 512) {
                DFilterFrame.this.uresp[i] = 1.0;
                ++i;
            }
            return 1;
        }

        @Override
        void setup() {
        }

        double getUserResponse(double w) {
            double q = DFilterFrame.this.uresp[(int)(w * (double)DFilterFrame.this.uresp.length / Math.PI)];
            return q * q;
        }

        void edit(double x, double x2, double y) {
            int xi1 = (int)(x * (double)DFilterFrame.this.uresp.length);
            int xi2 = (int)(x2 * (double)DFilterFrame.this.uresp.length);
            while (xi1 < xi2) {
                if (xi1 >= 0 && xi1 < DFilterFrame.this.uresp.length) {
                    DFilterFrame.this.uresp[xi1] = y;
                }
                ++xi1;
            }
        }

        @Override
        Filter genFilter() {
            int n = DFilterFrame.this.auxBars[0].getValue();
            int nsz = DFilterFrame.this.uresp.length * 4;
            double[] fbuf = new double[nsz];
            int nsz2 = nsz / 2;
            int nsz4 = nsz2 / 2;
            int i = 0;
            while (i != nsz4) {
                double ur;
                fbuf[i * 2] = ur = DFilterFrame.this.uresp[i] / (double)nsz2;
                if (i > 0) {
                    fbuf[nsz - i * 2] = ur;
                }
                ++i;
            }
            new FFT(nsz2).transform(fbuf, true);
            DirectFilter f = new DirectFilter();
            f.aList = new double[n];
            f.nList = new int[n];
            i = 0;
            while (i != n) {
                int i2 = (i - n / 2) * 2;
                f.aList[i] = fbuf[i2 & nsz - 1] * this.getWindow(i, n);
                f.nList[i] = i;
                ++i;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            int n = DFilterFrame.this.auxBars[0].getValue();
            x[0] = "Order: " + n;
        }

        @Override
        boolean needsWindow() {
            return true;
        }
    }

    class CustomIIRFilter
    extends IIRFilterType {
        int npoles;
        int nzeros;

        CustomIIRFilter(DFilterFrame dFilterFrame2) {
            super(dFilterFrame2);
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("# of Pole Pairs");
            DFilterFrame.this.auxBars[0].setMaximum(10);
            DFilterFrame.this.auxBars[0].setValue(DFilterFrame.this.lastPoleCount / 2);
            return 1;
        }

        @Override
        void setup() {
            this.npoles = this.nzeros = DFilterFrame.this.auxBars[0].getValue() * 2;
        }

        @Override
        void getPole(int i, Complex c1) {
            c1.set(DFilterFrame.this.customPoles[i]);
        }

        @Override
        int getPoleCount() {
            return this.npoles;
        }

        @Override
        void getZero(int i, Complex c1) {
            c1.set(DFilterFrame.this.customZeros[i]);
        }

        @Override
        int getZeroCount() {
            return this.nzeros;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Custom IIR";
            x[1] = String.valueOf(this.npoles) + " poles and zeros";
        }

        void editPoleZero(Complex c) {
            if (c.mag > 1.1) {
                return;
            }
            if (DFilterFrame.this.selectedPole != -1) {
                DFilterFrame.this.customPoles[DFilterFrame.this.selectedPole].set(c);
                DFilterFrame.this.customPoles[DFilterFrame.this.selectedPole ^ 1].set(c.re, -c.im);
            }
            if (DFilterFrame.this.selectedZero != -1) {
                DFilterFrame.this.customZeros[DFilterFrame.this.selectedZero].set(c);
                DFilterFrame.this.customZeros[DFilterFrame.this.selectedZero ^ 1].set(c.re, -c.im);
            }
        }
    }

    class DirectFilter
    extends Filter {
        double[] aList;
        double[] bList;
        int[] nList;
        Complex czn;
        Complex top;
        Complex bottom;

        DirectFilter() {
            super(DFilterFrame.this);
            this.aList = new double[]{1.0};
            this.bList = null;
            this.nList = new int[1];
        }

        @Override
        int getLength() {
            return this.aList.length;
        }

        @Override
        boolean useConvolve() {
            return this.bList == null && this.aList.length > 25;
        }

        void dump() {
            System.out.print("a ");
            this.dump(this.aList);
            if (this.bList != null) {
                System.out.print("b ");
                this.dump(this.bList);
            }
        }

        void dump(double[] x) {
            int i = 0;
            while (i != x.length) {
                System.out.print(String.valueOf(x[i]) + " ");
                ++i;
            }
            System.out.println("");
        }

        @Override
        void evalTransfer(Complex c) {
            if (this.czn == null) {
                this.czn = new Complex();
                this.top = new Complex();
                this.bottom = new Complex();
            }
            this.czn.set(1.0);
            this.top.set(0.0);
            this.bottom.set(0.0);
            int n = 0;
            int i = 0;
            while (i != this.aList.length) {
                int n1 = this.nList[i];
                while (n < n1) {
                    if (n + 3 < n1) {
                        this.czn.set(c);
                        this.czn.pow(-n1);
                        n = n1;
                        break;
                    }
                    this.czn.div(c);
                    ++n;
                }
                this.top.addMult(this.aList[i], this.czn);
                if (this.bList != null) {
                    this.bottom.addMult(this.bList[i], this.czn);
                }
                ++i;
            }
            if (this.bList != null) {
                this.top.div(this.bottom);
            }
            c.set(this.top);
        }

        @Override
        void run(double[] inBuf, double[] outBuf, int bp, int mask, int count, double[] state) {
            int fi2 = bp;
            double q = 0.0;
            int i2 = 0;
            while (i2 != count) {
                int ji;
                int j;
                fi2 = bp + i2;
                int i20 = fi2 & mask;
                q = inBuf[i20] * this.aList[0];
                if (this.bList == null) {
                    j = 1;
                    while (j < this.aList.length) {
                        ji = fi2 - this.nList[j] & mask;
                        q += inBuf[ji] * this.aList[j];
                        ++j;
                    }
                } else {
                    j = 1;
                    while (j < this.aList.length) {
                        ji = fi2 - this.nList[j] & mask;
                        q += inBuf[ji] * this.aList[j] - outBuf[ji] * this.bList[j];
                        ++j;
                    }
                }
                outBuf[i20] = q;
                ++i2;
            }
        }

        boolean isSimpleAList() {
            if (this.bList != null) {
                return false;
            }
            return this.nList[this.nList.length - 1] == this.nList.length - 1;
        }

        @Override
        int getImpulseOffset() {
            if (this.isSimpleAList()) {
                return 0;
            }
            return this.getStepOffset();
        }

        @Override
        int getStepOffset() {
            int offset = 0;
            int i = 0;
            while (i != this.aList.length) {
                if (this.nList[i] > offset) {
                    offset = this.nList[i];
                }
                ++i;
            }
            return offset;
        }

        @Override
        double[] getImpulseResponse(int offset) {
            if (this.isSimpleAList()) {
                return this.aList;
            }
            return super.getImpulseResponse(offset);
        }

        @Override
        int getImpulseLen(int offset, double[] buf) {
            if (this.isSimpleAList()) {
                return this.aList.length;
            }
            return DFilterFrame.this.countPoints(buf, offset);
        }
    }

    class FFT {
        double[] wtabf;
        double[] wtabi;
        int size;

        FFT(int sz) {
            this.size = sz;
            if ((this.size & this.size - 1) != 0) {
                System.out.println("size must be power of two!");
            }
            this.calcWTable();
        }

        void calcWTable() {
            this.wtabf = new double[this.size];
            this.wtabi = new double[this.size];
            int i = 0;
            while (i != this.size) {
                double pi = 3.1415926535;
                double th = pi * (double)i / (double)this.size;
                this.wtabf[i] = Math.cos(th);
                this.wtabf[i + 1] = Math.sin(th);
                this.wtabi[i] = this.wtabf[i];
                this.wtabi[i + 1] = -this.wtabf[i + 1];
                i += 2;
            }
        }

        void transform(double[] data, boolean inv) {
            double d2i;
            double d2r;
            double d1i;
            double d1r;
            int j = 0;
            int size2 = this.size * 2;
            if ((this.size & this.size - 1) != 0) {
                System.out.println("size must be power of two!");
            }
            int i = 0;
            while (i != size2) {
                if (i > j) {
                    double q = data[i];
                    data[i] = data[j];
                    data[j] = q;
                    q = data[i + 1];
                    data[i + 1] = data[j + 1];
                    data[j + 1] = q;
                }
                int bit = this.size;
                while ((bit & j) != 0) {
                    j &= ~bit;
                    bit >>= 1;
                }
                j |= bit;
                i += 2;
            }
            int tabskip = this.size << 1;
            double[] wtab = inv ? this.wtabi : this.wtabf;
            i = 0;
            while (i != size2) {
                d1r = data[i];
                d1i = data[i + 1];
                d2r = data[i + 2];
                d2i = data[i + 3];
                data[i] = d1r + d2r;
                data[i + 1] = d1i + d2i;
                data[i + 2] = d1r - d2r;
                data[i + 3] = d1i - d2i;
                i += 4;
            }
            tabskip >>= 1;
            int imult = inv ? -1 : 1;
            i = 0;
            while (i != size2) {
                d1r = data[i];
                d1i = data[i + 1];
                d2r = data[i + 4];
                d2i = data[i + 5];
                data[i] = d1r + d2r;
                data[i + 1] = d1i + d2i;
                data[i + 4] = d1r - d2r;
                data[i + 5] = d1i - d2i;
                d1r = data[i + 2];
                d1i = data[i + 3];
                d2r = data[i + 6] * (double)imult;
                d2i = data[i + 7] * (double)imult;
                data[i + 2] = d1r - d2i;
                data[i + 3] = d1i + d2r;
                data[i + 6] = d1r + d2i;
                data[i + 7] = d1i - d2r;
                i += 8;
            }
            tabskip >>= 1;
            int skip1 = 16;
            while (skip1 <= size2) {
                int skip2 = skip1 >> 1;
                tabskip >>= 1;
                i = 0;
                while (i != 1000) {
                    ++i;
                }
                i = 0;
                while (i < size2) {
                    int ix = 0;
                    j = i;
                    while (j != i + skip2) {
                        double wr = wtab[ix];
                        double wi = wtab[ix + 1];
                        d1r = data[j];
                        d1i = data[j + 1];
                        int j2 = j + skip2;
                        d2r = data[j2];
                        d2i = data[j2 + 1];
                        double d2wr = d2r * wr - d2i * wi;
                        double d2wi = d2r * wi + d2i * wr;
                        data[j] = d1r + d2wr;
                        data[j + 1] = d1i + d2wi;
                        data[j2] = d1r - d2wr;
                        data[j2 + 1] = d1i - d2wi;
                        j += 2;
                        ix += tabskip;
                    }
                    i += skip1;
                }
                skip1 <<= 1;
            }
        }
    }

    abstract class FIRFilterType
    extends FilterType {
        double[] response;

        FIRFilterType() {
            super(DFilterFrame.this);
        }

        @Override
        void getResponse(double w, Complex c) {
            if (this.response == null) {
                c.set(0.0);
                return;
            }
            int off = (int)((double)this.response.length * w / (Math.PI * 2));
            if ((off &= 0xFFFFFFFE) < 0) {
                off = 0;
            }
            if (off >= this.response.length) {
                off = this.response.length - 2;
            }
            c.set(this.response[off], this.response[off + 1]);
        }

        double getWindow(int i, int n) {
            if (n == 1) {
                return 1.0;
            }
            double x = Math.PI * 2 * (double)i / (double)(n - 1);
            double n2 = n / 2;
            switch (DFilterFrame.this.windowChooser.getSelectedIndex()) {
                case 0: {
                    return 1.0;
                }
                case 1: {
                    return 0.54 - 0.46 * Math.cos(x);
                }
                case 2: {
                    return 0.5 - 0.5 * Math.cos(x);
                }
                case 3: {
                    return 0.42 - 0.5 * Math.cos(x) + 0.08 * Math.cos(2.0 * x);
                }
                case 4: {
                    double kaiserAlphaPi = (double)DFilterFrame.this.kaiserBar.getValue() * Math.PI / 120.0;
                    double q = (double)(2 * i) / (double)n - 1.0;
                    return DFilterFrame.this.bessi0(kaiserAlphaPi * Math.sqrt(1.0 - q * q));
                }
                case 5: {
                    return (double)i < n2 ? (double)i / n2 : 2.0 - (double)i / n2;
                }
                case 6: {
                    double xt = ((double)i - n2) / n2;
                    return 1.0 - xt * xt;
                }
            }
            return 0.0;
        }

        void setResponse(DirectFilter f) {
            int i;
            this.response = new double[8192];
            if (f.nList.length != f.aList.length) {
                f.nList = new int[f.aList.length];
                i = 0;
                while (i != f.aList.length) {
                    f.nList[i] = i;
                    ++i;
                }
            }
            i = 0;
            while (i != f.aList.length) {
                this.response[f.nList[i] * 2] = f.aList[i];
                ++i;
            }
            new FFT(this.response.length / 2).transform(this.response, false);
            double maxresp = 0.0;
            int j = 0;
            while (j != this.response.length) {
                double r2 = this.response[j] * this.response[j] + this.response[j + 1] * this.response[j + 1];
                if (maxresp < r2) {
                    maxresp = r2;
                }
                j += 2;
            }
            maxresp = Math.sqrt(maxresp);
            j = 0;
            while (j != this.response.length) {
                int n = j++;
                this.response[n] = this.response[n] / maxresp;
            }
            j = 0;
            while (j != f.aList.length) {
                int n = j++;
                f.aList[n] = f.aList[n] / maxresp;
            }
        }
    }

    class GaussianFilter
    extends FIRFilterType {
        int n;
        double cw;

        GaussianFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Offset");
            DFilterFrame.this.auxBars[0].setMaximum(1000);
            DFilterFrame.this.auxBars[0].setValue(100);
            DFilterFrame.this.auxLabels[1].setText("Width");
            DFilterFrame.this.auxBars[1].setMaximum(1000);
            DFilterFrame.this.auxBars[1].setValue(100);
            DFilterFrame.this.auxLabels[2].setText("Order");
            DFilterFrame.this.auxBars[2].setMaximum(1600);
            DFilterFrame.this.auxBars[2].setValue(160);
            return 3;
        }

        @Override
        void setup() {
            this.n = DFilterFrame.this.auxBars[2].getValue();
            this.cw = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[this.n];
            double w = (double)DFilterFrame.this.auxBars[1].getValue() / 100000.0;
            int n2 = this.n / 2;
            int i = 0;
            while (i != this.n) {
                int ii = i - n2;
                f.aList[i] = Math.exp(-w * (double)ii * (double)ii) * Math.cos((double)ii * this.cw) * this.getWindow(i, this.n);
                ++i;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        boolean needsWindow() {
            return true;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Gaussian (FIR)";
            x[1] = "Order: " + this.n;
        }
    }

    class ImpulseWaveform
    extends Waveform {
        int ix;

        ImpulseWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.ix = 0;
            return true;
        }

        @Override
        int getData() {
            int ww = DFilterFrame.this.inputBar.getValue() / 51 + 1;
            int period = 10000 / ww;
            int i = 0;
            while (i != this.buffer.length) {
                int q = 0;
                if (this.ix % period == 0) {
                    q = Short.MAX_VALUE;
                }
                ++this.ix;
                this.buffer[i] = q;
                ++i;
            }
            return this.buffer.length;
        }

        @Override
        String getInputText() {
            return "Impulse Frequency";
        }

        @Override
        boolean needsFrequency() {
            return false;
        }
    }

    class InverseCombFilter
    extends FIRFilterType {
        int n;
        double mult;
        double peak;

        InverseCombFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("2nd Zero");
            DFilterFrame.this.auxBars[0].setValue(60);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(1000);
            return 2;
        }

        @Override
        void setup() {
            this.n = 1990 / DFilterFrame.this.auxBars[0].getValue();
            this.mult = (double)DFilterFrame.this.auxBars[1].getValue() / 1000.0;
            this.peak = 1.0 + this.mult;
        }

        @Override
        void getZero(int i, Complex c1) {
            c1.setMagPhase(Math.pow(this.mult, 1.0 / (double)this.n), Math.PI * 2 * (double)i / (double)this.n);
        }

        @Override
        int getZeroCount() {
            return this.n;
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[]{1.0 / this.peak, -this.mult / this.peak};
            int[] nArray = new int[2];
            nArray[1] = this.n;
            f.nList = nArray;
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Inverse Comb (FIR)";
            x[1] = "Zeros every " + DFilterFrame.this.getOmegaText(Math.PI * 2 / (double)this.n);
        }
    }

    class MovingAverageFilter
    extends FIRFilterType {
        double n;
        int ni;

        MovingAverageFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxBars[0].setValue(500);
            return 1;
        }

        @Override
        void setup() {
            this.n = 2000.0 / (double)DFilterFrame.this.auxBars[0].getValue();
            if (this.n > 1000.0) {
                this.n = 1000.0;
            }
            this.ni = (int)this.n;
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[this.ni + 1];
            int i = 0;
            while (i != this.ni) {
                f.aList[i] = 1.0 / this.n;
                ++i;
            }
            f.aList[i] = (this.n - (double)this.ni) / this.n;
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Moving Average (FIR)";
            x[1] = "Cutoff: " + DFilterFrame.this.getOmegaText(Math.PI * 2 / this.n);
            x[2] = "Length: " + DFilterFrame.this.showFormat.format(this.n);
        }
    }

    class Mp3Waveform
    extends Waveform {
        Decoder decoder;
        Bitstream bitstream;
        Header header;
        boolean first;
        SampleBuffer output;
        String fileName;
        BufferedInputStream bis;

        Mp3Waveform(int f) {
            this.fileName = DFilterFrame.this.mp3List[f];
        }

        @Override
        boolean start() {
            this.first = false;
            try {
                if (this.bis != null) {
                    try {
                        this.bis.reset();
                    }
                    catch (Exception e) {
                        this.bis = null;
                    }
                }
                if (this.bis == null) {
                    URL url = new URL(DFilterFrame.this.applet.getCodeBase() + this.fileName);
                    Object o = url.getContent();
                    if (o instanceof BufferedInputStream) {
                        this.bis = (BufferedInputStream)o;
                    } else {
                        FilterInputStream fs = (FilterInputStream)o;
                        this.bis = new BufferedInputStream(fs);
                    }
                    this.bis.mark(200000);
                }
                this.bitstream = new Bitstream((InputStream)this.bis);
                this.header = this.bitstream.readFrame();
                this.decoder = new Decoder();
                this.output = (SampleBuffer)this.decoder.decodeFrame(this.header, this.bitstream);
                DFilterFrame.this.setSampleRate(this.decoder.getOutputFrequency());
                DFilterFrame.this.rateChooser.setEnabled(false);
                this.first = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                DFilterFrame.this.mp3Error = "Can't open " + this.fileName;
                return false;
            }
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        int getData() {
            if (!this.first) {
                try {
                    this.bitstream.closeFrame();
                    this.header = this.bitstream.readFrame();
                    if (this.header == null) {
                        if (!this.start()) {
                            return 0;
                        }
                        return this.getData();
                    }
                    this.output = (SampleBuffer)this.decoder.decodeFrame(this.header, this.bitstream);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            } else {
                this.first = false;
            }
            this.buffer = this.output.getBuffer();
            return this.output.getBufferLength();
        }

        @Override
        int getChannels() {
            return this.decoder.getOutputChannels();
        }

        @Override
        String getInputText() {
            return null;
        }

        @Override
        boolean needsFrequency() {
            return false;
        }
    }

    class NoFilter
    extends FilterType {
        NoFilter() {
            super(DFilterFrame.this);
        }

        @Override
        void getResponse(double w, Complex c) {
            c.set(1.0);
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[1];
            f.aList[0] = 1.0;
            return f;
        }
    }

    class NoiseWaveform
    extends Waveform {
        NoiseWaveform() {
        }

        @Override
        boolean start() {
            this.getBuffer();
            return true;
        }

        @Override
        int getData() {
            int i = 0;
            while (i != this.buffer.length) {
                this.buffer[i] = (short)DFilterFrame.this.random.nextInt();
                ++i;
            }
            return this.buffer.length;
        }

        @Override
        String getInputText() {
            return null;
        }

        @Override
        boolean needsFrequency() {
            return false;
        }
    }

    class PeriodicNoiseWaveform
    extends Waveform {
        short[] smbuf;
        int ix;

        PeriodicNoiseWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.smbuf = new short[1];
            this.ix = 0;
            return true;
        }

        @Override
        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                i = 0;
                while (i != period) {
                    this.smbuf[i] = (short)DFilterFrame.this.random.nextInt();
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class PhaseColor {
        public double r;
        public double g;
        public double b;

        PhaseColor(double rr, double gg, double bb) {
            this.r = rr;
            this.g = gg;
            this.b = bb;
        }
    }

    class PlayThread
    extends Thread {
        SourceDataLine line;
        Waveform wform;
        boolean shutdownRequested = false;
        boolean stereo;
        Filter filt;
        Filter newFilter;
        double[] fbufLi;
        double[] fbufRi;
        double[] fbufLo;
        double[] fbufRo;
        double[] stateL;
        double[] stateR;
        int fbufmask;
        int fbufsize;
        int spectrumOffset;
        int spectrumLen;
        int inbp;
        int outbp;
        int spectCt;
        double[] impulseBuf;
        double[] convolveBuf;
        int convBufPtr;
        FFT convFFT;
        byte[] ob;

        PlayThread() {
        }

        void requestShutdown() {
            this.shutdownRequested = true;
        }

        void setFilter(Filter f) {
            this.newFilter = f;
        }

        void openLine() {
            try {
                this.stereo = this.wform.getChannels() == 2;
                AudioFormat playFormat = new AudioFormat(DFilterFrame.this.sampleRate, 16, 2, true, false);
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, playFormat);
                if (!AudioSystem.isLineSupported(info)) {
                    throw new LineUnavailableException("sorry, the sound format cannot be played");
                }
                this.line = (SourceDataLine)AudioSystem.getLine(info);
                this.line.open(playFormat, DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 4));
                this.line.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            DFilterFrame.this.playThread = null;
        }

        void doRun() {
            DFilterFrame.this.rateChooser.setEnabled(true);
            this.wform = DFilterFrame.this.getWaveformObject();
            DFilterFrame.this.mp3Error = null;
            DFilterFrame.this.unstable = false;
            if (!this.wform.start()) {
                DFilterFrame.this.cv.repaint();
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.fbufsize = 32768;
            this.fbufmask = this.fbufsize - 1;
            this.fbufLi = new double[this.fbufsize];
            this.fbufRi = new double[this.fbufsize];
            this.fbufLo = new double[this.fbufsize];
            this.fbufRo = new double[this.fbufsize];
            this.openLine();
            this.spectCt = 0;
            this.outbp = 0;
            this.inbp = 0;
            int ss = this.stereo ? 2 : 1;
            DFilterFrame.this.outputGain = 1.0;
            this.newFilter = this.filt = DFilterFrame.this.curFilter;
            this.spectrumLen = DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 12);
            int gainCounter = 0;
            boolean maxGain = true;
            boolean useConvolve = false;
            this.ob = new byte[16384];
            int shiftCtr = 0;
            while (!this.shutdownRequested && DFilterFrame.this.soundCheck.getState() && DFilterFrame.this.applet.ogf != null) {
                int length;
                if (this.newFilter != null) {
                    gainCounter = 0;
                    maxGain = true;
                    if (this.wform instanceof SweepWaveform || this.wform instanceof SineWaveform) {
                        maxGain = false;
                    }
                    DFilterFrame.this.outputGain = 1.0;
                    if (this.filt == null || this.filt.getLength() != this.newFilter.getLength()) {
                        this.spectCt = 0;
                        this.outbp = 0;
                        this.inbp = 0;
                        this.convBufPtr = 0;
                    }
                    this.filt = this.newFilter;
                    this.newFilter = null;
                    this.impulseBuf = null;
                    useConvolve = this.filt.useConvolve();
                    this.stateL = this.filt.createState();
                    this.stateR = this.filt.createState();
                }
                if ((length = this.wform.getData()) == 0) break;
                short[] ib = this.wform.buffer;
                int i = this.inbp;
                int i2 = 0;
                while (i2 < length) {
                    this.fbufLi[i] = ib[i2];
                    i = i + 1 & this.fbufmask;
                    i2 += ss;
                }
                i = this.inbp;
                if (this.stereo) {
                    i2 = 0;
                    while (i2 < length) {
                        this.fbufRi[i] = ib[i2 + 1];
                        i = i + 1 & this.fbufmask;
                        i2 += 2;
                    }
                } else {
                    i2 = 0;
                    while (i2 < length) {
                        this.fbufRi[i] = this.fbufLi[i];
                        i = i + 1 & this.fbufmask;
                        ++i2;
                    }
                }
                if (DFilterFrame.this.shiftSpectrumCheck.getState()) {
                    double shiftFreq = (double)DFilterFrame.this.shiftFreqBar.getValue() * Math.PI / 1000.0;
                    if (shiftFreq > Math.PI) {
                        shiftFreq = Math.PI;
                    }
                    i = this.inbp;
                    i2 = 0;
                    while (i2 < length) {
                        double q = Math.cos(shiftFreq * (double)shiftCtr++);
                        int n = i;
                        this.fbufLi[n] = this.fbufLi[n] * q;
                        int n2 = i;
                        this.fbufRi[n2] = this.fbufRi[n2] * q;
                        i = i + 1 & this.fbufmask;
                        i2 += ss;
                    }
                }
                int sampleCount = length / ss;
                if (useConvolve) {
                    this.doConvolveFilter(sampleCount, maxGain);
                } else {
                    this.doFilter(sampleCount);
                    if (DFilterFrame.this.unstable) break;
                    int outlen = sampleCount * 4;
                    this.doOutput(outlen, maxGain);
                }
                if (DFilterFrame.this.unstable) break;
                if (this.spectCt >= this.spectrumLen) {
                    this.spectrumOffset = this.outbp - this.spectrumLen & this.fbufmask;
                    this.spectCt -= this.spectrumLen;
                    DFilterFrame.this.cv.repaint();
                }
                if (!maxGain || (gainCounter += sampleCount) < DFilterFrame.this.sampleRate) continue;
                gainCounter = 0;
                maxGain = false;
            }
            if (this.shutdownRequested || DFilterFrame.this.unstable || !DFilterFrame.this.soundCheck.getState()) {
                this.line.flush();
            } else {
                this.line.drain();
            }
            DFilterFrame.this.cv.repaint();
        }

        void doFilter(int sampleCount) {
            this.filt.run(this.fbufLi, this.fbufLo, this.inbp, this.fbufmask, sampleCount, this.stateL);
            this.filt.run(this.fbufRi, this.fbufRo, this.inbp, this.fbufmask, sampleCount, this.stateR);
            this.inbp = this.inbp + sampleCount & this.fbufmask;
            double q = this.fbufLo[this.inbp - 1 & this.fbufmask];
            if (Double.isNaN(q) || Double.isInfinite(q)) {
                DFilterFrame.this.unstable = true;
            }
        }

        void doConvolveFilter(int sampleCount, boolean maxGain) {
            int i;
            int fi2 = this.inbp;
            double[] filtA = ((DirectFilter)this.filt).aList;
            int cblen = DFilterFrame.this.getPower2(512 + filtA.length * 2);
            if (this.convolveBuf == null || this.convolveBuf.length != cblen) {
                this.convolveBuf = new double[cblen];
            }
            if (this.impulseBuf == null) {
                this.impulseBuf = new double[cblen];
                i = 0;
                while (i != filtA.length) {
                    this.impulseBuf[i * 2] = filtA[i];
                    ++i;
                }
                this.convFFT = new FFT(this.convolveBuf.length / 2);
                this.convFFT.transform(this.impulseBuf, false);
            }
            int cbptr = this.convBufPtr;
            int cbptrmax = this.convolveBuf.length + 2 - 2 * filtA.length;
            i = 0;
            while (i != sampleCount) {
                int i20 = fi2 & this.fbufmask;
                this.convolveBuf[cbptr] = this.fbufLi[i20];
                this.convolveBuf[cbptr + 1] = this.fbufRi[i20];
                if ((cbptr += 2) == cbptrmax) {
                    int j20;
                    this.convFFT.transform(this.convolveBuf, false);
                    double mult = 2.0 / (double)cblen;
                    int j = 0;
                    while (j != cblen) {
                        double a = this.convolveBuf[j] * this.impulseBuf[j] - this.convolveBuf[j + 1] * this.impulseBuf[j + 1];
                        double b = this.convolveBuf[j] * this.impulseBuf[j + 1] + this.convolveBuf[j + 1] * this.impulseBuf[j];
                        this.convolveBuf[j] = a * mult;
                        this.convolveBuf[j + 1] = b * mult;
                        j += 2;
                    }
                    this.convFFT.transform(this.convolveBuf, true);
                    int fj2 = this.outbp;
                    int overlap = cblen - cbptrmax;
                    j = 0;
                    while (j != overlap) {
                        int n = j20 = fj2 & this.fbufmask;
                        this.fbufLo[n] = this.fbufLo[n] + this.convolveBuf[j];
                        int n2 = j20;
                        this.fbufRo[n2] = this.fbufRo[n2] + this.convolveBuf[j + 1];
                        j += 2;
                        ++fj2;
                    }
                    while (j != cblen) {
                        j20 = fj2 & this.fbufmask;
                        this.fbufLo[j20] = this.convolveBuf[j];
                        this.fbufRo[j20] = this.convolveBuf[j + 1];
                        j += 2;
                        ++fj2;
                    }
                    cbptr = 0;
                    this.doOutput(cbptrmax * 2, maxGain);
                    j = 0;
                    while (j != cblen) {
                        this.convolveBuf[j] = 0.0;
                        ++j;
                    }
                }
                ++i;
                ++fi2;
            }
            this.inbp = fi2 & this.fbufmask;
            this.convBufPtr = cbptr;
        }

        void doOutput(int outlen, boolean maxGain) {
            int i;
            if (this.ob.length < outlen) {
                this.ob = new byte[outlen];
            }
            while (true) {
                int qi;
                int max = 0;
                i = this.outbp;
                int i2 = 0;
                while (i2 < outlen) {
                    qi = (int)(this.fbufLo[i] * DFilterFrame.this.outputGain);
                    if (qi > max) {
                        max = qi;
                    }
                    if (qi < -max) {
                        max = -qi;
                    }
                    this.ob[i2 + 1] = (byte)(qi >> 8);
                    this.ob[i2] = (byte)qi;
                    i = i + 1 & this.fbufmask;
                    i2 += 4;
                }
                i = this.outbp;
                i2 = 2;
                while (i2 < outlen) {
                    qi = (int)(this.fbufRo[i] * DFilterFrame.this.outputGain);
                    if (qi > max) {
                        max = qi;
                    }
                    if (qi < -max) {
                        max = -qi;
                    }
                    this.ob[i2 + 1] = (byte)(qi >> 8);
                    this.ob[i2] = (byte)qi;
                    i = i + 1 & this.fbufmask;
                    i2 += 4;
                }
                if (max > Short.MAX_VALUE) {
                    DFilterFrame.this.outputGain *= 30000.0 / (double)max;
                    if (!(DFilterFrame.this.outputGain < 1.0E-8) && !Double.isInfinite(DFilterFrame.this.outputGain)) continue;
                    DFilterFrame.this.unstable = true;
                    break;
                }
                if (!maxGain || max >= 24000) break;
                if (max == 0) {
                    if (DFilterFrame.this.outputGain == 1.0) break;
                    DFilterFrame.this.outputGain = 1.0;
                    continue;
                }
                DFilterFrame.this.outputGain *= 30000.0 / (double)max;
            }
            if (DFilterFrame.this.unstable) {
                return;
            }
            this.outbp = i;
            this.line.write(this.ob, 0, outlen);
            this.spectCt += outlen / 4;
        }
    }

    class PluckedStringFilter
    extends IIRFilterType {
        int n;
        double mult;

        PluckedStringFilter(DFilterFrame dFilterFrame2) {
            super(dFilterFrame2);
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Fundamental");
            DFilterFrame.this.auxBars[0].setValue(20);
            DFilterFrame.this.auxLabels[1].setText("Sharpness");
            DFilterFrame.this.auxBars[1].setValue(970);
            return 2;
        }

        @Override
        void setup() {
            this.n = 2000 / DFilterFrame.this.auxBars[0].getValue();
            this.mult = 0.5 * Math.exp(-0.5 + (double)DFilterFrame.this.auxBars[1].getValue() / 2000.0);
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[]{1.0, 1.0, 0.0, 0.0};
            f.bList = new double[]{1.0, 0.0, -this.mult, -this.mult};
            int[] nArray = new int[4];
            nArray[1] = 1;
            nArray[2] = this.n;
            nArray[3] = this.n + 1;
            f.nList = nArray;
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Plucked String (IIR); Resonance every " + DFilterFrame.this.getOmegaText(Math.PI * 2 / (double)this.n);
            x[1] = "Delay: " + this.n + " samples, " + DFilterFrame.this.getUnitText((double)this.n / (double)DFilterFrame.this.sampleRate, "s");
        }
    }

    class RandomFilter
    extends FIRFilterType {
        int n;

        RandomFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Order");
            DFilterFrame.this.auxBars[0].setMaximum(1600);
            DFilterFrame.this.auxBars[0].setValue(100);
            return 1;
        }

        @Override
        void setCutoff(double f) {
        }

        @Override
        void setup() {
            this.n = DFilterFrame.this.auxBars[0].getValue();
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[this.n];
            int i = 0;
            while (i != this.n) {
                f.aList[i] = (double)DFilterFrame.this.random.nextInt() * this.getWindow(i, this.n);
                ++i;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        boolean needsWindow() {
            return true;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Random (FIR)";
            x[1] = "Order: " + this.n;
        }
    }

    class SawtoothWaveform
    extends Waveform {
        int ix;
        short[] smbuf;

        SawtoothWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        @Override
        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                double p2 = (double)period / 2.0;
                i = 0;
                while (i != period) {
                    this.smbuf[i] = (short)(((double)i / p2 - 1.0) * 32000.0);
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class SincBandPassFilter
    extends SincBandStopFilter {
        SincBandPassFilter() {
            this.invert = true;
        }
    }

    class SincBandStopFilter
    extends FIRFilterType {
        int n;
        double wc1;
        double wc2;
        double mult;
        double peak;
        double[] resp;
        boolean invert;

        SincBandStopFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Center Frequency");
            DFilterFrame.this.auxLabels[1].setText(this.invert ? "Passband Width" : "Stopband Width");
            DFilterFrame.this.auxLabels[2].setText("Order");
            DFilterFrame.this.auxBars[0].setValue(500);
            DFilterFrame.this.auxBars[1].setValue(50);
            DFilterFrame.this.auxBars[2].setValue(140);
            DFilterFrame.this.auxBars[2].setMaximum(1600);
            return 3;
        }

        @Override
        void setup() {
            double wcmid = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            double width = (double)DFilterFrame.this.auxBars[1].getValue() * Math.PI / 1000.0;
            this.wc1 = wcmid - width;
            this.wc2 = wcmid + width;
            if (this.wc1 < 0.0) {
                this.wc1 = 0.0;
            }
            if (this.wc2 > Math.PI) {
                this.wc2 = Math.PI;
            }
            this.n = DFilterFrame.this.auxBars[2].getValue();
        }

        @Override
        int getPoleCount() {
            return 0;
        }

        @Override
        void getPole(int i, Complex c1) {
        }

        @Override
        Filter genFilter() {
            int ii;
            DirectFilter f = new DirectFilter();
            f.aList = new double[this.n + 1];
            double[] xlist = new double[this.n + 1];
            int n2 = this.n / 2;
            double sum = 0.0;
            int i = 0;
            while (i != this.n) {
                ii = i - n2;
                f.aList[i] = (ii == 0 ? this.wc1 : Math.sin(this.wc1 * (double)ii) / (double)ii) * this.getWindow(i, this.n);
                sum += f.aList[i];
                ++i;
            }
            if (sum > 0.0) {
                i = 0;
                while (i != this.n) {
                    int n = i++;
                    f.aList[n] = f.aList[n] / sum;
                }
            }
            sum = 0.0;
            i = 0;
            while (i != this.n) {
                ii = i - n2;
                xlist[i] = (ii == 0 ? this.wc2 : Math.sin(this.wc2 * (double)ii) / (double)ii) * this.getWindow(i, this.n);
                sum += xlist[i];
                ++i;
            }
            i = 0;
            while (i != this.n) {
                int n = i++;
                xlist[n] = xlist[n] / sum;
            }
            i = 0;
            while (i != this.n) {
                int n = i;
                f.aList[n] = f.aList[n] - xlist[i];
                ++i;
            }
            int n = n2;
            f.aList[n] = f.aList[n] + 1.0;
            if (this.invert) {
                i = 0;
                while (i != this.n) {
                    f.aList[i] = -f.aList[i];
                    ++i;
                }
                int n3 = n2;
                f.aList[n3] = f.aList[n3] + 1.0;
            }
            if (this.n == 1) {
                f.aList[0] = 1.0;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = this.invert ? "Passband: " : "Stopband: ";
            x[0] = String.valueOf(x[0]) + DFilterFrame.this.getOmegaText(this.wc1) + " - " + DFilterFrame.this.getOmegaText(this.wc2);
            x[1] = "Order: " + this.n;
        }

        @Override
        boolean needsWindow() {
            return true;
        }
    }

    class SincHighPassFilter
    extends SincLowPassFilter {
        SincHighPassFilter() {
            this.invert = true;
        }
    }

    class SincLowPassFilter
    extends FIRFilterType {
        int n;
        double wc;
        double mult;
        double peak;
        double[] resp;
        boolean invert;

        SincLowPassFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxLabels[1].setText("Order");
            DFilterFrame.this.auxBars[0].setValue(this.invert ? 500 : 100);
            DFilterFrame.this.auxBars[1].setValue(120);
            DFilterFrame.this.auxBars[1].setMaximum(1600);
            return 2;
        }

        @Override
        void setup() {
            this.wc = (double)DFilterFrame.this.auxBars[0].getValue() * Math.PI / 1000.0;
            this.n = DFilterFrame.this.auxBars[1].getValue();
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[this.n];
            int n2 = this.n / 2;
            double sum = 0.0;
            int i = 0;
            while (i != this.n) {
                int ii = i - n2;
                f.aList[i] = (ii == 0 ? this.wc : Math.sin(this.wc * (double)ii) / (double)ii) * this.getWindow(i, this.n);
                sum += f.aList[i];
                ++i;
            }
            i = 0;
            while (i != this.n) {
                int n = i++;
                f.aList[n] = f.aList[n] / sum;
            }
            if (this.invert) {
                i = 0;
                while (i != this.n) {
                    f.aList[i] = -f.aList[i];
                    ++i;
                }
                int n = n2;
                f.aList[n] = f.aList[n] + 1.0;
            }
            if (this.n == 1) {
                f.aList[0] = 1.0;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Cutoff freq: " + DFilterFrame.this.getOmegaText(this.wc);
            x[1] = "Order: " + this.n;
        }

        @Override
        boolean needsWindow() {
            return true;
        }
    }

    class SineWaveform
    extends Waveform {
        int ix;

        SineWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.ix = 0;
            return true;
        }

        @Override
        int getData() {
            int i = 0;
            while (i != this.buffer.length) {
                ++this.ix;
                this.buffer[i] = (short)(Math.sin((double)this.ix * DFilterFrame.this.inputW) * 32000.0);
                ++i;
            }
            return this.buffer.length;
        }
    }

    class SquareWaveform
    extends Waveform {
        int ix;
        double omega;
        short[] smbuf;

        SquareWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        @Override
        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                i = 0;
                while (i != period / 2) {
                    this.smbuf[i] = 32000;
                    ++i;
                }
                if ((period & 1) > 0) {
                    this.smbuf[i++] = 0;
                }
                while (i != period) {
                    this.smbuf[i] = -32000;
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class SweepWaveform
    extends Waveform {
        int ix;
        double omega;
        double nextOmega;
        double t;
        double startOmega;

        SweepWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.nextOmega = this.omega = 251.32741228718345 / (double)DFilterFrame.this.sampleRate;
            this.startOmega = this.omega;
            this.t = 0.0;
            return true;
        }

        @Override
        int getData() {
            double nmul = 1.0;
            double nadd = 0.0;
            double maxspeed = 1.0 / (0.66 * (double)DFilterFrame.this.sampleRate);
            double minspeed = 1 / (DFilterFrame.this.sampleRate * 16);
            if (DFilterFrame.this.logFreqCheckItem.getState()) {
                nmul = Math.pow(Math.PI * 2 / this.startOmega, 2.0 * (minspeed + (maxspeed - minspeed) * (double)DFilterFrame.this.inputBar.getValue() / 1000.0));
            } else {
                nadd = (Math.PI * 2 - this.startOmega) * (minspeed + (maxspeed - minspeed) * (double)DFilterFrame.this.inputBar.getValue() / 1000.0);
            }
            int i = 0;
            while (i != this.buffer.length) {
                ++this.ix;
                this.t += this.omega;
                if (this.t > Math.PI * 2) {
                    this.t -= Math.PI * 2;
                    this.omega = this.nextOmega;
                    if (this.nextOmega > Math.PI) {
                        this.omega = this.nextOmega = this.startOmega;
                    }
                }
                this.buffer[i] = (short)(Math.sin(this.t) * 32000.0);
                this.nextOmega = this.nextOmega * nmul + nadd;
                ++i;
            }
            return this.buffer.length;
        }

        @Override
        String getInputText() {
            return "Sweep Speed";
        }

        @Override
        boolean needsFrequency() {
            return false;
        }
    }

    class TriangleFilter
    extends FIRFilterType {
        int ni;
        double n;

        TriangleFilter() {
        }

        @Override
        int select() {
            DFilterFrame.this.auxLabels[0].setText("Cutoff Frequency");
            DFilterFrame.this.auxBars[0].setValue(500);
            return 1;
        }

        @Override
        void setup() {
            this.n = 4000.0 / (double)DFilterFrame.this.auxBars[0].getValue();
            if (this.n > 1000.0) {
                this.n = 1000.0;
            }
            this.ni = (int)this.n;
        }

        @Override
        Filter genFilter() {
            DirectFilter f = new DirectFilter();
            f.aList = new double[this.ni + 1];
            double sum = 0.0;
            double n2 = this.n / 2.0;
            int i = 0;
            while ((double)i < this.n) {
                double q = 0.0;
                q = (double)i < n2 ? (double)i / n2 : 2.0 - (double)i / n2;
                sum += q;
                f.aList[i] = q;
                ++i;
            }
            i = 0;
            while (i != f.aList.length) {
                int n = i++;
                f.aList[n] = f.aList[n] / sum;
            }
            this.setResponse(f);
            return f;
        }

        @Override
        void getInfo(String[] x) {
            x[0] = "Triangle (FIR)";
            x[1] = "Cutoff: " + DFilterFrame.this.getOmegaText(Math.PI * 4 / this.n);
            x[2] = "Length: " + DFilterFrame.this.showFormat.format(this.n);
        }
    }

    class TriangleWaveform
    extends Waveform {
        int ix;
        short[] smbuf;

        TriangleWaveform() {
        }

        @Override
        int getChannels() {
            return 1;
        }

        @Override
        boolean start() {
            this.getBuffer();
            this.ix = 0;
            this.smbuf = new short[1];
            return true;
        }

        @Override
        int getData() {
            int i;
            int period = (int)(Math.PI * 2 / DFilterFrame.this.inputW);
            if (period != this.smbuf.length) {
                this.smbuf = new short[period];
                double p2 = (double)period / 2.0;
                i = 0;
                while ((double)i < p2) {
                    this.smbuf[i] = (short)((double)i / p2 * 64000.0 - 32000.0);
                    ++i;
                }
                while (i != period) {
                    this.smbuf[i] = (short)((2.0 - (double)i / p2) * 64000.0 - 32000.0);
                    ++i;
                }
            }
            i = 0;
            while (i != this.buffer.length) {
                if (this.ix >= period) {
                    this.ix = 0;
                }
                this.buffer[i] = this.smbuf[this.ix];
                ++i;
                ++this.ix;
            }
            return this.buffer.length;
        }
    }

    class View
    extends Rectangle {
        int right;
        int bottom;

        View(Dimension r) {
            super(r);
        }

        View(int a, int b, int c, int d) {
            super(a, b, c, d);
            this.right = a + c - 1;
            this.bottom = b + d - 1;
        }

        void drawLabel(Graphics g, String str) {
            g.setColor(Color.white);
            DFilterFrame.this.centerString(g, str, this.y - 5);
        }
    }

    abstract class Waveform {
        short[] buffer;

        Waveform() {
        }

        boolean start() {
            return true;
        }

        abstract int getData();

        int getChannels() {
            return 2;
        }

        void getBuffer() {
            this.buffer = new short[DFilterFrame.this.getPower2(DFilterFrame.this.sampleRate / 12) * this.getChannels()];
        }

        String getInputText() {
            return "Input Frequency";
        }

        boolean needsFrequency() {
            return true;
        }
    }
}

