/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.EllipticBandStop;
import org.corebounce.common.dsp.iir.EllipticFilterType;

class EllipticBandPass
extends EllipticFilterType {
    private final DFilterFrame dFilterFrame;

    EllipticBandPass(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
        this.dFilterFrame = dFilterFrame;
    }

    @Override
    int select() {
        int s = this.selectBandPass();
        this.dFilterFrame.auxBars[2].setValue(5);
        this.selectElliptic(s);
        return s + 2;
    }

    @Override
    void setup() {
        this.setupBandPass();
        this.setupElliptic(3);
    }

    @Override
    void getPole(int i, Complex c1) {
        this.getBandPassPole(i, c1);
    }

    @Override
    void getZero(int i, Complex c1) {
        this.getEllipticZero(i / 2, c1, 1.5707963267948966);
        this.bandPassXform(i, c1);
    }

    @Override
    int getPoleCount() {
        return this.n * 2;
    }

    @Override
    int getZeroCount() {
        return this.n * 2;
    }

    @Override
    void getInfo(String[] x) {
        x[0] = "Elliptic (IIR), " + this.getPoleCount() + "-pole";
        this.getInfoBandPass(x, this instanceof EllipticBandStop);
        this.getInfoElliptic(x);
    }
}

