/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;

abstract class Filter {
    private final DFilterFrame dFilterFrame;

    Filter(DFilterFrame dFilterFrame) {
        this.dFilterFrame = dFilterFrame;
    }

    abstract void run(double[] var1, double[] var2, int var3, int var4, int var5, double[] var6);

    abstract void evalTransfer(Complex var1);

    abstract int getImpulseOffset();

    abstract int getStepOffset();

    abstract int getLength();

    boolean useConvolve() {
        return false;
    }

    double[] getImpulseResponse(int offset) {
        int pts = 1000;
        double[] inbuf = new double[offset + pts];
        double[] outbuf = new double[offset + pts];
        inbuf[offset] = 1.0;
        double[] state = this.createState();
        this.run(inbuf, outbuf, offset, -1, pts, state);
        return outbuf;
    }

    double[] getStepResponse(int offset) {
        int pts = 1000;
        double[] inbuf = new double[offset + pts];
        double[] outbuf = new double[offset + pts];
        int i = offset;
        while (i != inbuf.length) {
            inbuf[i] = 1.0;
            ++i;
        }
        double[] state = this.createState();
        this.run(inbuf, outbuf, offset, -1, pts, state);
        return outbuf;
    }

    int getImpulseLen(int offset, double[] buf) {
        return this.dFilterFrame.countPoints(buf, offset);
    }

    int getStepLen(int offset, double[] buf) {
        return this.dFilterFrame.countPoints(buf, offset);
    }

    double[] createState() {
        return null;
    }
}

