/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.CascadeFilter;
import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.Filter;
import org.corebounce.common.dsp.iir.FilterType;

abstract class IIRFilterType
extends FilterType {
    double[] response;

    IIRFilterType(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
    }

    @Override
    void getResponse(double w, Complex c) {
        if (this.response == null) {
            c.set(0.0);
            return;
        }
        int off = (int)((double)this.response.length * w / Math.PI);
        if ((off &= 0xFFFFFFFE) < 0) {
            off = 0;
        }
        if (off >= this.response.length) {
            off = this.response.length - 1;
        }
        c.set(this.response[off], this.response[off + 1]);
    }

    void setResponse(DFilterFrame.DirectFilter f) {
        this.response = new double[8192];
        Complex czn = new Complex();
        Complex top = new Complex();
        Complex bottom = new Complex();
        double maxresp = 0.0;
        f.bList[0] = 1.0;
        if (f.aList.length != f.bList.length) {
            System.out.println("length mismatch " + f.aList.length + " " + f.bList.length);
        }
        int j = 0;
        while (j != this.response.length) {
            top.set(0.0);
            bottom.set(0.0);
            int i = 0;
            while (i != f.aList.length) {
                czn.setMagPhase(1.0, -Math.PI * (double)j * (double)f.nList[i] / (double)this.response.length);
                top.addMult(f.aList[i], czn);
                bottom.addMult(f.bList[i], czn);
                ++i;
            }
            top.div(bottom);
            if (top.mag > maxresp) {
                maxresp = top.mag;
            }
            this.response[j] = top.re;
            this.response[j + 1] = top.im;
            j += 2;
        }
        j = 0;
        while (j != this.response.length) {
            int n = j++;
            this.response[n] = this.response[n] / maxresp;
        }
        j = 0;
        while (j != f.aList.length) {
            int n = j++;
            f.aList[n] = f.aList[n] / maxresp;
        }
    }

    void setResponse(CascadeFilter f) {
        this.response = new double[4096];
        Complex czn1 = new Complex();
        Complex czn2 = new Complex();
        Complex ch = new Complex();
        Complex ct = new Complex();
        Complex cb = new Complex();
        Complex cbot = new Complex();
        double maxresp = 0.0;
        int j = 0;
        while (j != this.response.length) {
            ch.set(1.0);
            cbot.set(1.0);
            czn1.setMagPhase(1.0, -Math.PI * (double)j / (double)this.response.length);
            czn2.setMagPhase(1.0, -Math.PI * (double)j * 2.0 / (double)this.response.length);
            int i = 0;
            while (i != f.size) {
                ct.set(f.b0[i]);
                cb.set(1.0);
                ct.addMult(f.b1[i], czn1);
                cb.addMult(-f.a1[i], czn1);
                ct.addMult(f.b2[i], czn2);
                cb.addMult(-f.a2[i], czn2);
                ch.mult(ct);
                cbot.mult(cb);
                ++i;
            }
            ch.div(cbot);
            if (ch.mag > maxresp) {
                maxresp = ch.mag;
            }
            this.response[j] = ch.re;
            this.response[j + 1] = ch.im;
            j += 2;
        }
        j = 0;
        while (j != this.response.length) {
            int n = j++;
            this.response[n] = this.response[n] / maxresp;
        }
        f.b0[0] = f.b0[0] / maxresp;
        f.b1[0] = f.b1[0] / maxresp;
        f.b2[0] = f.b2[0] / maxresp;
    }

    @Override
    Filter genFilter() {
        double cd0;
        double cc0;
        int n = this.getPoleCount();
        CascadeFilter f = new CascadeFilter(this.dFilterFrame, (n + 1) / 2);
        Complex c1 = new Complex();
        int i = 0;
        while (i != n) {
            this.getPole(i, c1);
            if (Math.abs(c1.im) < 1.0E-6) {
                c1.im = 0.0;
            }
            if (!(c1.im < 0.0)) {
                if (c1.im == 0.0) {
                    cc0 = -c1.re;
                    f.setAStage(-cc0, 0.0);
                } else {
                    cc0 = -2.0 * c1.re;
                    cd0 = c1.magSquared();
                    f.setAStage(-cc0, -cd0);
                }
            }
            ++i;
        }
        n = this.getZeroCount();
        i = 0;
        while (i != n) {
            this.getZero(i, c1);
            if (Math.abs(c1.im) < 1.0E-6) {
                c1.im = 0.0;
            }
            if (!(c1.im < 0.0)) {
                if (c1.im == 0.0) {
                    f.setBStage(1.0, -c1.re, 0.0);
                } else {
                    cc0 = -2.0 * c1.re;
                    cd0 = c1.magSquared();
                    f.setBStage(1.0, cc0, cd0);
                }
            }
            ++i;
        }
        this.setResponse(f);
        return f;
    }
}

