/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.InvChebyBandStop;
import org.corebounce.common.dsp.iir.InvChebyFilterType;

class InvChebyBandPass
extends InvChebyFilterType {
    InvChebyBandPass(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
    }

    @Override
    int select() {
        int s = this.selectBandPass();
        this.selectCheby(s++);
        return s;
    }

    @Override
    void setup() {
        this.setupBandPass();
        this.setupCheby(3);
    }

    @Override
    void getPole(int i, Complex c1) {
        this.getBandPassPole(i, c1);
    }

    @Override
    void getZero(int i, Complex c1) {
        this.getChebyZero(i / 2, c1, 1.5707963267948966);
        this.bandPassXform(i, c1);
    }

    @Override
    int getPoleCount() {
        return this.n * 2;
    }

    @Override
    int getZeroCount() {
        return this.n * 2;
    }

    @Override
    void getInfo(String[] x) {
        x[0] = "Inv Cheby (IIR), " + this.getPoleCount() + "-pole";
        this.getInfoBandPass(x, this instanceof InvChebyBandStop);
        this.getInfoCheby(x);
    }
}

