/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.IIRFilterType;

abstract class PoleFilterType
extends IIRFilterType {
    int n;
    double wc;
    double wc2;

    PoleFilterType(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
    }

    abstract void getSPole(int var1, Complex var2, double var3);

    @Override
    void getPole(int i, Complex c1) {
        this.getSPole(i, c1, this.wc);
        this.bilinearXform(c1);
    }

    void bilinearXform(Complex c1) {
        Complex c2 = new Complex(c1);
        c1.add(1.0);
        c2.mult(-1.0);
        c2.add(1.0);
        c1.div(c2);
    }

    int selectLowPass() {
        this.dFilterFrame.auxLabels[0].setText("Cutoff Frequency");
        this.dFilterFrame.auxLabels[1].setText("Number of Poles");
        this.dFilterFrame.auxBars[1].setMaximum(40);
        this.dFilterFrame.auxBars[0].setValue(100);
        this.dFilterFrame.auxBars[1].setValue(4);
        return 2;
    }

    int selectBandPass() {
        this.dFilterFrame.auxLabels[0].setText("Center Frequency");
        this.dFilterFrame.auxLabels[1].setText("Passband Width");
        this.dFilterFrame.auxLabels[2].setText("Number of Poles");
        this.dFilterFrame.auxBars[2].setMaximum(20);
        this.dFilterFrame.auxBars[0].setValue(500);
        this.dFilterFrame.auxBars[1].setValue(200);
        this.dFilterFrame.auxBars[2].setValue(6);
        return 3;
    }

    void getBandPassPole(int i, Complex z) {
        this.getSPole(i / 2, z, 1.5707963267948966);
        this.bilinearXform(z);
        this.bandPassXform(i, z);
    }

    void bandPassXform(int i, Complex z) {
        double a = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
        double b = 1.0 / Math.tan(0.5 * (this.wc - this.wc2));
        Complex c2 = new Complex();
        c2.addMult(4.0 * (b * b * (a * a - 1.0) + 1.0), z);
        c2.add(8.0 * (b * b * (a * a - 1.0) - 1.0));
        c2.mult(z);
        c2.add(4.0 * (b * b * (a * a - 1.0) + 1.0));
        c2.sqrt();
        if ((i & 1) == 0) {
            c2.mult(-1.0);
        }
        c2.addMult(2.0 * a * b, z);
        c2.add(2.0 * a * b);
        Complex c3 = new Complex();
        c3.addMult(2.0 * (b - 1.0), z);
        c3.add(2.0 * (1.0 + b));
        c2.div(c3);
        z.set(c2);
    }

    void getBandStopPole(int i, Complex z) {
        this.getSPole(i / 2, z, 1.5707963267948966);
        this.bilinearXform(z);
        this.bandStopXform(i, z);
    }

    void getBandStopZero(int i, Complex z) {
        z.set(-1.0, 0.0);
        this.bandStopXform(i, z);
    }

    void bandStopXform(int i, Complex z) {
        double a = Math.cos((this.wc + this.wc2) * 0.5) / Math.cos((this.wc - this.wc2) * 0.5);
        double b = Math.tan(0.5 * (this.wc - this.wc2));
        Complex c2 = new Complex();
        c2.addMult(4.0 * (b * b + a * a - 1.0), z);
        c2.add(8.0 * (b * b - a * a + 1.0));
        c2.mult(z);
        c2.add(4.0 * (a * a + b * b - 1.0));
        c2.sqrt();
        c2.mult((i & 1) == 0 ? 0.5 : -0.5);
        c2.add(a);
        c2.addMult(-a, z);
        Complex c3 = new Complex(b + 1.0, 0.0);
        c3.addMult(b - 1.0, z);
        c2.div(c3);
        z.set(c2);
    }

    void getBandPassZero(int i, Complex c1) {
        if (i >= this.n) {
            c1.set(1.0);
        } else {
            c1.set(-1.0);
        }
    }

    void setupLowPass() {
        this.wc = (double)this.dFilterFrame.auxBars[0].getValue() * Math.PI / 1000.0;
        this.n = this.dFilterFrame.auxBars[1].getValue();
    }

    void setupBandPass() {
        double wcmid = (double)this.dFilterFrame.auxBars[0].getValue() * Math.PI / 1000.0;
        double width = (double)this.dFilterFrame.auxBars[1].getValue() * Math.PI / 1000.0;
        this.wc = wcmid + width / 2.0;
        this.wc2 = wcmid - width / 2.0;
        if (this.wc2 < 0.0) {
            this.wc2 = 1.0E-8;
        }
        if (this.wc >= Math.PI) {
            this.wc = 3.141592643589793;
        }
        this.n = this.dFilterFrame.auxBars[2].getValue();
    }

    void getInfoLowPass(String[] x) {
        x[1] = "Cutoff freq: " + this.dFilterFrame.getOmegaText(this.wc);
    }

    void getInfoBandPass(String[] x, boolean stop) {
        x[1] = String.valueOf(stop ? "Stopband: " : "Passband: ") + this.dFilterFrame.getOmegaText(this.wc2) + " - " + this.dFilterFrame.getOmegaText(this.wc);
    }
}

