/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.mfcc;

public class FFT {
    protected int numPoints;
    public float[] real;
    public float[] imag;

    public void computeFFT(float[] signal) {
        this.numPoints = signal.length;
        this.real = new float[this.numPoints];
        this.imag = new float[this.numPoints];
        this.real = signal;
        int i = 0;
        while (i < this.imag.length) {
            this.imag[i] = 0.0f;
            ++i;
        }
        this.computeFFT();
    }

    private void computeFFT() {
        int halfNumPoints;
        if (this.numPoints == 1) {
            return;
        }
        double pi = Math.PI;
        int numStages = (int)(Math.log(this.numPoints) / Math.log(2.0));
        int j = halfNumPoints = this.numPoints >> 1;
        int k = 0;
        int i = 1;
        while (i < this.numPoints - 2) {
            if (i < j) {
                float tempReal = this.real[j];
                float tempImag = this.imag[j];
                this.real[j] = this.real[i];
                this.imag[j] = this.imag[i];
                this.real[i] = tempReal;
                this.imag[i] = tempImag;
            }
            k = halfNumPoints;
            while (k <= j) {
                j -= k;
                k >>= 1;
            }
            j += k;
            ++i;
        }
        int stage = 1;
        while (stage <= numStages) {
            int LE = 1;
            int i2 = 0;
            while (i2 < stage) {
                LE <<= 1;
                ++i2;
            }
            int LE2 = LE >> 1;
            double UR = 1.0;
            double UI = 0.0;
            double SR = Math.cos(Math.PI / (double)LE2);
            double SI = -Math.sin(Math.PI / (double)LE2);
            int subDFT = 1;
            while (subDFT <= LE2) {
                int butterfly = subDFT - 1;
                while (butterfly <= this.numPoints - 1) {
                    int ip = butterfly + LE2;
                    float tempReal = (float)((double)this.real[ip] * UR - (double)this.imag[ip] * UI);
                    float tempImag = (float)((double)this.real[ip] * UI + (double)this.imag[ip] * UR);
                    this.real[ip] = this.real[butterfly] - tempReal;
                    this.imag[ip] = this.imag[butterfly] - tempImag;
                    int n = butterfly;
                    this.real[n] = this.real[n] + tempReal;
                    int n2 = butterfly;
                    this.imag[n2] = this.imag[n2] + tempImag;
                    butterfly += LE;
                }
                double tempUR = UR;
                UR = tempUR * SR - UI * SI;
                UI = tempUR * SI + UI * SR;
                ++subDFT;
            }
            ++stage;
        }
    }
}

