/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.dsp.resample.LinearInterpolatedBuffer;

public class KaiserLiBuffer
extends LinearInterpolatedBuffer {
    private final float scaleFactor;

    public KaiserLiBuffer(int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb) {
        super(nbSamplesPerZeroCross * nbZeroCross + nbSamplesPerZeroCross / 2 + 2);
        this.scaleFactor = (float)nbSamplesPerZeroCross / (float)Math.PI;
        float[] kaiserWindow = new float[nbSamplesPerZeroCross * nbZeroCross * 2];
        Windows.fillKaiserWindow(kaiserWindow, kaiserWindow.length, kaiserAttenuationDb);
        int i = 0;
        while (i < super.getSize()) {
            float windowCoeff = 0.0f;
            if (i <= kaiserWindow.length / 2) {
                windowCoeff = kaiserWindow[kaiserWindow.length / 2 - i];
            }
            super.set(i, windowCoeff);
            ++i;
        }
    }

    @Override
    public float get(float angle) {
        float index = angle * this.scaleFactor;
        if (index < 0.0f) {
            return super.get(-index);
        }
        return super.get(index);
    }

    @Override
    public float get(int index) {
        if (index < 0) {
            return super.get(-index);
        }
        return super.get(index);
    }

    public float getPos(int index) {
        return super.get(index);
    }
}

