/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.BufferedResampler;
import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.math.Fraction;

public class LinearResampler
extends BufferedResampler
implements IResampler {
    private final int step;
    private int index;
    private final int denom;
    private final float frac;

    public LinearResampler(IAudioSource source, Fraction ratio, int bufferSize) {
        super(source, bufferSize, 1);
        Fraction srcStep = Fraction.inverse(ratio).seal();
        this.denom = (int)srcStep.getDenom();
        this.step = (int)(srcStep.getNum() + srcStep.getBase() * srcStep.getDenom());
        this.frac = 1.0f / (float)this.denom;
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.index = this.bufferSize * this.denom - this.step;
    }

    @Override
    public int resample(float[] output) {
        int floor = 0;
        int i = 0;
        while (i < output.length) {
            this.index += this.step;
            floor = this.index / this.denom;
            floor -= super.prefetch(floor + 1);
            float v1 = super.getSample(floor);
            float v2 = super.getSample(floor + 1);
            float weight = (float)(this.index % this.denom) * this.frac;
            output[i] = v1 + (v2 - v1) * weight;
            ++i;
        }
        if (floor <= this.eosIndex) {
            return output.length;
        }
        floor = (this.index + this.step) / this.denom;
        return output.length - ((floor - this.eosIndex) * this.denom + this.step / 2) / this.step;
    }

    @Override
    protected void fetchNextBuffer() {
        super.fetchNextBuffer();
        this.index -= this.bufferSize * this.denom;
    }

    @Override
    public int getLatency() {
        return 1;
    }
}

