/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.SincConvolvedAudioSource;
import org.corebounce.common.math.Fraction;

public class PolyphaseResampler
implements IResampler {
    private final SincConvolvedAudioSource source;
    private final int latency;

    public PolyphaseResampler(IAudioSource source, Fraction ratio, int nbZeroCross, float kaiserAttenuationDb, float antiAliasing, int bufferSize) {
        if (nbZeroCross < 1) {
            throw new IllegalArgumentException();
        }
        float amplitudeCorrection = Math.min(ratio.floatValue(), 1.0f);
        if (!ratio.equals(1L) && (double)antiAliasing != 0.0) {
            amplitudeCorrection = (float)((double)amplitudeCorrection * (1.0 - (double)antiAliasing + (double)(antiAliasing * PolyphaseResampler.getBandWidth(nbZeroCross))));
        }
        float sincStretch = 1.0f / amplitudeCorrection;
        this.source = new SincConvolvedAudioSource(source, Fraction.inverse(ratio), nbZeroCross, kaiserAttenuationDb, bufferSize, sincStretch, amplitudeCorrection);
        this.latency = nbZeroCross;
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public int resample(float[] output) {
        return this.source.getSamples(output, 0, output.length);
    }

    static float getBandWidth(int nbZeroCross) {
        float rollOff = 1.0f / ((float)nbZeroCross / 2.0f + 1.0f);
        return 1.0f - rollOff;
    }

    @Override
    public int getLatency() {
        return this.latency;
    }
}

