/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.dsp.resample.LinearInterpolatedBuffer;

public class SincLiBuffer
extends LinearInterpolatedBuffer {
    private final float scaleFactor;

    public SincLiBuffer(int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float stretch) {
        super(nbSamplesPerZeroCross * nbZeroCross + nbSamplesPerZeroCross / 2 + 2);
        this.scaleFactor = (float)nbSamplesPerZeroCross / (float)Math.PI;
        this.fillData(nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, stretch);
    }

    private void fillData(int samplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float stretch) {
        float[] kaiserWindow = new float[samplesPerZeroCross * nbZeroCross * 2];
        Windows.fillKaiserWindow(kaiserWindow, kaiserWindow.length, kaiserAttenuationDb);
        double nrj2 = 0.0;
        int i = 0;
        while (i < super.getSize()) {
            float angle = (float)i / (float)samplesPerZeroCross;
            float windowCoeff = 0.0f;
            if (i <= kaiserWindow.length / 2) {
                windowCoeff = kaiserWindow[kaiserWindow.length / 2 - i];
            }
            float value = this.sinc(angle / stretch) * windowCoeff;
            nrj2 += (double)(value * value);
            super.set(i, value);
            ++i;
        }
        double nrj1 = (double)samplesPerZeroCross * (double)stretch / 2.0;
        if (stretch > 1.0f) {
            float correction = (float)(Math.sqrt(nrj1) / Math.sqrt(nrj2));
            int i2 = 0;
            while (i2 < super.getSize()) {
                super.mult(i2, correction);
                ++i2;
            }
        }
    }

    SincLiBuffer(int nbSamplesPerZeroCross, int nbZeroCross) {
        super(nbSamplesPerZeroCross * nbZeroCross + nbSamplesPerZeroCross / 2 + 2);
        this.scaleFactor = (float)nbSamplesPerZeroCross / (float)Math.PI;
        int i = 0;
        while (i < super.getSize()) {
            float angle = (float)i / (float)nbSamplesPerZeroCross;
            super.set(i, this.sinc(angle));
            ++i;
        }
    }

    private float sinc(float angle) {
        if (angle == 0.0f) {
            return 1.0f;
        }
        return (float)(Math.sin(Math.PI * (double)angle) / (Math.PI * (double)angle));
    }

    @Override
    public float get(float angle) {
        float index = angle * this.scaleFactor;
        if (index < 0.0f) {
            return super.get(-index);
        }
        return super.get(index);
    }

    public float getPreScaled(float angle) {
        return super.get(angle);
    }

    @Override
    public float get(int index) {
        if (index < 0) {
            return super.get(-index);
        }
        return super.get(index);
    }

    public float getPos(int index) {
        return super.get(index);
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public static void main(String[] args) {
        SincLiBuffer buffer = new SincLiBuffer(10, 7, 80.0f, 1.0f);
        float max = 23.561945f;
        float step = 0.15707964f;
        float a = -max;
        while (a < max) {
            float value = buffer.get(a);
            int k = (int)((value + 1.0f) * 60.0f + 0.5f);
            int i = 30;
            while (i <= 120) {
                if (i == k) {
                    System.out.print("*");
                } else if (i == 60) {
                    System.out.print("|");
                } else {
                    System.out.print(" ");
                }
                ++i;
            }
            System.out.println(String.valueOf(a) + ":" + value);
            a += step;
        }
    }
}

