/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.PolyphaseResampler;
import org.corebounce.common.dsp.resample.SincLiConvolvedAudioSource;
import org.corebounce.common.math.Fraction;

public class SincResampler
implements IResampler {
    private final SincLiConvolvedAudioSource source;
    private final int latency;

    public SincResampler(IAudioSource source, Fraction ratio, int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float antiAliasing, int bufferSize) {
        if (nbZeroCross < 1) {
            throw new IllegalArgumentException();
        }
        float amplitudeCorrection = Math.min(ratio.floatValue(), 1.0f);
        if (!ratio.equals(1L) && (double)antiAliasing != 0.0) {
            amplitudeCorrection = (float)((double)amplitudeCorrection * (1.0 - (double)antiAliasing + (double)(antiAliasing * PolyphaseResampler.getBandWidth(nbZeroCross))));
        }
        float sincStretch = 1.0f / amplitudeCorrection;
        Fraction srcStep = Fraction.inverse(ratio).seal();
        this.source = new SincLiConvolvedAudioSource(source, nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, sincStretch, bufferSize, srcStep, amplitudeCorrection);
        this.latency = nbZeroCross;
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public int resample(float[] output) {
        return this.source.getSamples(output, 0, output.length);
    }

    @Override
    public int getLatency() {
        return this.latency;
    }
}

