/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.BufferedResampler;
import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.ISweepableResampler;

public class SweepableLinearResampler
extends BufferedResampler
implements ISweepableResampler {
    private double step;
    private double index;

    public SweepableLinearResampler(IAudioSource source, double ratio, int bufferSize) {
        super(source, bufferSize, 1);
        this.step = 1.0 / ratio;
        this.reset();
    }

    @Override
    public void setRatio(double ratio) {
        this.step = 1.0 / ratio;
    }

    @Override
    public void reset() {
        super.reset();
        this.index = (double)this.bufferSize - this.step;
    }

    @Override
    public int resample(float[] output) {
        int floor = 0;
        int i = 0;
        while (i < output.length) {
            this.index += this.step;
            floor = (int)this.index;
            floor -= super.prefetch(floor + 1);
            float v1 = super.getSample(floor);
            float v2 = super.getSample(floor + 1);
            float weight = (float)(this.index % 1.0);
            output[i] = v1 + (v2 - v1) * weight;
            ++i;
        }
        if (floor <= this.eosIndex) {
            return output.length;
        }
        floor = (int)(this.index + this.step);
        return (int)((double)output.length - (double)(floor - this.eosIndex) / this.step + 0.5);
    }

    @Override
    protected void fetchNextBuffer() {
        super.fetchNextBuffer();
        this.index -= (double)this.bufferSize;
    }

    @Override
    public int getLatency() {
        return 1;
    }
}

