/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.ISweepableResampler;
import org.corebounce.common.dsp.resample.SweepableSincLiConvolvedAudioSource;

public class SweepableSincResampler
implements ISweepableResampler {
    private final SweepableSincLiConvolvedAudioSource source;
    private final int latency;

    public SweepableSincResampler(IAudioSource source, double ratio, int nbSamplesPerZeroCross, int nbZeroCross, float kaiserAttenuationDb, float antiAliasing, int bufferSize) {
        if (nbZeroCross < 1) {
            throw new IllegalArgumentException();
        }
        this.source = new SweepableSincLiConvolvedAudioSource(source, nbSamplesPerZeroCross, nbZeroCross, kaiserAttenuationDb, bufferSize, antiAliasing, ratio);
        this.latency = nbZeroCross;
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public int resample(float[] output) {
        return this.source.getSamples(output, 0, output.length);
    }

    @Override
    public void setRatio(double ratio) {
        this.source.setRatio(ratio);
    }

    @Override
    public int getLatency() {
        return this.latency;
    }
}

