/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.ISweepableResampler;

public class ZeroLatencyResampleWrapper
implements ISweepableResampler {
    private final IResampler target;
    private int latency;
    private float[] buffer;
    private boolean isFirst;

    public ZeroLatencyResampleWrapper(IResampler target, double ratio) {
        this.target = target;
        this.latency = (int)((double)target.getLatency() * ratio + 0.5);
        this.buffer = new float[this.latency];
        this.isFirst = true;
    }

    @Override
    public int resample(float[] output) {
        if (this.isFirst) {
            this.target.resample(this.buffer);
        }
        this.isFirst = false;
        return this.target.resample(output);
    }

    @Override
    public void reset() {
        this.target.reset();
        this.isFirst = true;
    }

    @Override
    public int getLatency() {
        return 0;
    }

    @Override
    public void setRatio(double ratio) {
        if (!(this.target instanceof ISweepableResampler)) {
            throw new UnsupportedOperationException();
        }
        ((ISweepableResampler)this.target).setRatio(ratio);
        this.latency = (int)((double)this.target.getLatency() * ratio + 0.5);
        this.buffer = new float[this.latency];
    }
}

