/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.corebounce.common.gui.AwtTools;

public class Console {
    private PrintStream stream;

    public Console(String name, boolean exitOnClose) {
        this.init(name, exitOnClose);
    }

    public static void redirectStdOutAndStdErr(boolean exitOnClose) {
        Console out = new Console("Std Out", exitOnClose);
        System.setOut(out.getPrintStream());
        Console err = new Console("Std Err", false);
        System.setErr(err.getPrintStream());
    }

    private void init(String name, boolean exitOnClose) {
        final JFrame frame = new JFrame(name);
        frame.setLayout(new BorderLayout());
        if (exitOnClose) {
            frame.setDefaultCloseOperation(3);
        } else {
            frame.setDefaultCloseOperation(1);
        }
        final JTextArea area = new JTextArea();
        area.setEditable(false);
        JScrollPane scroller = new JScrollPane(area);
        frame.getContentPane().add(scroller);
        frame.setPreferredSize(new Dimension(800, 300));
        OutputStream target = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                this.append("" + (char)b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                String data = new String(b, off, len);
                this.append(data);
            }

            private void append(final String data) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!frame.isVisible()) {
                            frame.setVisible(true);
                        }
                        area.append(data);
                    }
                });
            }
        };
        this.stream = new PrintStream(target);
        frame.pack();
        AwtTools.centerWindowOnScreen(frame);
        frame.setVisible(true);
    }

    public PrintStream getPrintStream() {
        return this.stream;
    }
}

