/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import org.corebounce.common.utils.Platform;

public class ImageUtils {
    public static Image getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, GraphicsConfiguration gc, int quality) {
        int h;
        int w;
        if (quality == 2 && (targetWidth < img.getWidth() || targetHeight < img.getHeight())) {
            return img.getScaledInstance(targetWidth, targetHeight, 4);
        }
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage result = img;
        if (quality >= 1) {
            w = Math.max(img.getWidth(), targetWidth);
            h = Math.max(img.getHeight(), targetHeight);
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (quality >= 1 && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (quality >= 1 && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            Object rh = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            if (quality >= 2) {
                rh = RenderingHints.VALUE_INTERPOLATION_BICUBIC;
            } else if (quality >= 1) {
                rh = RenderingHints.VALUE_INTERPOLATION_BILINEAR;
            }
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, rh);
            if (img.getTransparency() != 1) {
                g2.setComposite(AlphaComposite.Src);
            }
            g2.drawImage(result, 0, 0, w, h, null);
            g2.dispose();
            result = tmp;
        } while (w != targetWidth || h != targetHeight);
        return result;
    }

    public static int[] getPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (w == 0 || h == 0) {
            return new int[0];
        }
        if (pixels == null) {
            pixels = new int[w * h];
        } else if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            return (int[])raster.getDataElements(x, y, w, h, pixels);
        }
        return img.getRGB(x, y, w, h, pixels, 0, w);
    }

    public static void setPixels(BufferedImage img, int x, int y, int w, int h, int[] pixels) {
        if (pixels == null || w == 0 || h == 0) {
            return;
        }
        if (pixels.length < w * h) {
            throw new IllegalArgumentException("pixels array must have a length >= w*h");
        }
        int imageType = img.getType();
        if (imageType == 2 || imageType == 1) {
            WritableRaster raster = img.getRaster();
            raster.setDataElements(x, y, w, h, pixels);
        } else {
            img.setRGB(x, y, w, h, pixels, 0, w);
        }
    }

    public static int[] getBackingRgbArray(BufferedImage img) {
        DataBuffer dataBuffer = img.getRaster().getDataBuffer();
        if (dataBuffer instanceof DataBufferInt) {
            return ((DataBufferInt)dataBuffer).getData();
        }
        return null;
    }

    public static void copyArea(Graphics2D g, int x, int y, int width, int height, int dx, int dy) {
        if (dy == 0 && dx < 0 && !Platform.isMacOsX() && !Platform.isWindows()) {
            g.copyArea(x, y, width, height, dx, -1);
            g.copyArea(0, y, width + dx, height, 0, 1);
        } else {
            g.copyArea(x, y, width, height, dx, dy);
        }
    }
}

