/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ResourceLoader {
    public static InputStream getResource(Class<?> forClass, String name) {
        String prefix = forClass.getPackage().getName().replace('.', '/');
        name = "/" + prefix + "/" + name;
        InputStream input = forClass.getResourceAsStream(name);
        return input;
    }

    public static Reader getResourceReader(Class<?> forClass, String name) {
        InputStream input = ResourceLoader.getResource(forClass, name);
        if (input == null) {
            return null;
        }
        try {
            InputStreamReader reader0 = new InputStreamReader(input, "UTF-8");
            BufferedReader reader = new BufferedReader(reader0);
            return reader;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getResourceAsString(Class<?> forClass, String name) {
        try {
            Reader reader = ResourceLoader.getResourceReader(forClass, name);
            char[] buffer = new char[4096];
            StringBuilder builder = new StringBuilder();
            int read = reader.read(buffer);
            while (read > 0) {
                builder.append(buffer, 0, read);
                read = reader.read(buffer);
            }
            reader.close();
            return builder.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getResourceAsString(Reader reader) {
        try {
            char[] buffer = new char[4096];
            StringBuilder builder = new StringBuilder();
            int read = reader.read(buffer);
            while (read > 0) {
                builder.append(buffer, 0, read);
                read = reader.read(buffer);
            }
            reader.close();
            return builder.toString();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

