/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.math;

public class ShellSort {
    private static final int[] STEPS = new int[]{1, 5, 19, 41, 109, 209, 505, 929, 2161, 3905, 8929, 16001, 36289, 64769, 146305, 260609, 587521, 1045505, 2354689, 4188161, 9427969, 16764929, 37730305, 67084289, 150958081, 268386305, 603906049, 1073643521};

    public static void sort(int[] indexes, float[] values, int count) {
        assert (indexes.length == values.length);
        if (count <= 1) {
            return;
        }
        int hi = 0;
        while (hi < STEPS.length && STEPS[hi] <= count) {
            ++hi;
        }
        while (hi > 0) {
            int step = STEPS[--hi];
            int offset = 0;
            while (offset < step) {
                int j = offset + step;
                while (j < count) {
                    int k = j;
                    int cur = indexes[k];
                    int prev = indexes[k - step];
                    if (values[cur] > values[prev]) {
                        do {
                            indexes[k] = prev;
                        } while ((k -= step) > offset && values[cur] > values[prev = indexes[k - step]]);
                        indexes[k] = cur;
                    }
                    j += step;
                }
                ++offset;
            }
        }
    }
}

