/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.math;

import org.corebounce.common.math.Statistics;

public class TwinStatistics {
    private final Statistics xStats = new Statistics();
    private final Statistics yStats = new Statistics();
    private double sumProd;

    public void add(double x, double y) {
        this.xStats.add(x);
        this.yStats.add(y);
        this.sumProd += x * y;
    }

    public void remove(double x, double y) {
        this.xStats.remove(x);
        this.yStats.remove(y);
        this.sumProd -= x * y;
    }

    public int getCount() {
        assert (this.xStats.getCount() == this.yStats.getCount());
        return this.xStats.getCount();
    }

    public double getSumX() {
        return this.xStats.getSum();
    }

    public double getSumY() {
        return this.yStats.getSum();
    }

    public double getSumSquareX() {
        return this.xStats.getSumSquare();
    }

    public double getSumSquareY() {
        return this.yStats.getSumSquare();
    }

    public double getMeanX() {
        return this.xStats.getMean();
    }

    public double getMeanY() {
        return this.yStats.getMean();
    }

    public double getVarianceX() {
        return this.xStats.getVariance();
    }

    public double getVarianceY() {
        return this.yStats.getVariance();
    }

    public double getStdDeviationX() {
        return this.xStats.getStdDeviation();
    }

    public double getStdDeviationY() {
        return this.yStats.getStdDeviation();
    }

    public double getCrossVariance() {
        return (this.sumProd - this.getMeanX() * this.getMeanY()) / (double)this.getCount();
    }

    public double getCrossCorrelation() {
        return this.getCrossVariance() / Math.sqrt(this.getVarianceX() * this.getVarianceY());
    }

    public double getRegressionY(double x) {
        return this.getCrossVariance() / this.getVarianceX() * (x - this.getMeanX()) + this.getMeanY();
    }

    public double getRegressionX(double y) {
        return this.getCrossVariance() / this.getVarianceY() * (y - this.getMeanY()) + this.getMeanX();
    }

    public void reset() {
        this.xStats.reset();
        this.yStats.reset();
        this.sumProd = 0.0;
    }
}

