/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct;

import ch.tachyon.tunnel.utils.Utils;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class TreeNode<T>
extends AbstractCollection<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private T value;
    private TreeNode<T> parent;
    private List<TreeNode<T>> children;
    private transient String structurePrefix;

    public TreeNode() {
    }

    public TreeNode(T value) {
        this.value = value;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public TreeNode<T> getRoot() {
        TreeNode<T> root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    protected void setParent(TreeNode<T> parent) {
        this.parent = parent;
    }

    protected List<TreeNode<T>> children() {
        if (this.children == null) {
            this.children = new ArrayList<TreeNode<T>>();
        }
        return this.children;
    }

    public boolean removeChild(TreeNode<T> child) {
        boolean result = this.children().remove(child);
        if (result) {
            child.setParent(null);
        }
        return result;
    }

    public boolean remove() {
        if (this.getParent() == null) {
            return false;
        }
        return this.getParent().removeChild(this);
    }

    public void addChild(TreeNode<T> child) {
        this.addChild(this.children().size(), child);
    }

    public void addChild(int index, TreeNode<T> child) {
        if (child.getParent() != null) {
            throw new IllegalArgumentException("The given child already has a parent. Remove it from its current parent first.");
        }
        this.children().add(index, child);
        child.setParent(this);
    }

    public boolean containsChild(TreeNode<T> child) {
        return this.children().contains(child);
    }

    public List<TreeNode<T>> getChildren() {
        return Collections.unmodifiableList(this.children());
    }

    public List<T> getChildElements() {
        ArrayList<T> result = new ArrayList<T>(this.children().size());
        for (TreeNode<T> child : this.children()) {
            result.add(child.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public int getDepth() {
        if (this.getParent() == null) {
            return 0;
        }
        return this.getParent().getDepth() + 1;
    }

    public TreeNode<T> nodeOf(T value) {
        if (Utils.eq(this.getValue(), value)) {
            return this;
        }
        for (TreeNode<T> child : this.children()) {
            TreeNode<T> result = child.nodeOf(value);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public TreeNode<T> walk(int ... indexes) {
        TreeNode<T> result = this;
        int[] nArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            result = index < 0 ? result.getParent() : result.getChildren().get(index);
            ++n2;
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public List<T> preOrderTraversal() {
        ArrayList result = new ArrayList();
        this.preOrderTraversal(result);
        return result;
    }

    private void preOrderTraversal(List<T> result) {
        result.add(this.getValue());
        for (TreeNode<T> child : this.children()) {
            super.preOrderTraversal(result);
        }
    }

    public List<T> postOrderTraversal() {
        ArrayList result = new ArrayList();
        this.postOrderTraversal(result);
        return result;
    }

    private void postOrderTraversal(List<T> result) {
        for (TreeNode<T> child : this.children()) {
            super.preOrderTraversal(result);
        }
        result.add(this.getValue());
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public List<TreeNode<T>> getLeaves() {
        ArrayList<TreeNode<T>> result = new ArrayList<TreeNode<T>>();
        this.fillLeaves(result);
        return result;
    }

    private void fillLeaves(List<TreeNode<T>> result) {
        if (this.children().isEmpty()) {
            result.add(this);
        } else {
            for (TreeNode<T> child : this.children()) {
                super.fillLeaves(result);
            }
        }
    }

    public static <T> List<T> unwrap(Collection<TreeNode<T>> nodes) {
        ArrayList<T> result = new ArrayList<T>(nodes.size());
        for (TreeNode<T> node : nodes) {
            result.add(node.getValue());
        }
        return result;
    }

    @Override
    public boolean contains(Object o) {
        TreeNode<Object> node = this.nodeOf(o);
        return node != null;
    }

    @Override
    public int size() {
        int result = 1;
        for (TreeNode<T> child : this.children()) {
            result += child.size();
        }
        return result;
    }

    @Override
    public boolean add(T e) {
        TreeNode<T> node = new TreeNode<T>(e);
        this.addChild(node);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        TreeNode<Object> node = this.nodeOf(o);
        if (node != null) {
            return node.remove();
        }
        return false;
    }

    public String getStructurePrefix() {
        if (this.structurePrefix == null) {
            super.fillStructurePrefixes("", 0, true);
        }
        assert (this.structurePrefix != null);
        return this.structurePrefix;
    }

    private void fillStructurePrefixes(String prefix, int indent, boolean isLast) {
        StringBuilder curPrefix = new StringBuilder();
        curPrefix.append(prefix);
        String nextPrefix = prefix;
        if (indent > 0) {
            if (isLast) {
                curPrefix.append("\u2514");
                nextPrefix = String.valueOf(nextPrefix) + " ";
            } else {
                curPrefix.append("\u251c");
                nextPrefix = String.valueOf(nextPrefix) + "\u2502";
            }
        }
        int lastIndex = this.children().size() - 1;
        int i = 0;
        while (i <= lastIndex) {
            TreeNode<T> child = this.children().get(i);
            super.fillStructurePrefixes(nextPrefix, indent + 1, i == lastIndex);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(Utils.NEW_LINE);
        this.toString(result, "", 0, true);
        return result.toString();
    }

    private void toString(StringBuilder result, String prefix, int indent, boolean isLast) {
        result.append(prefix);
        String nextPrefix = prefix;
        if (indent > 0) {
            if (isLast) {
                result.append("\u2514\u2500");
                nextPrefix = String.valueOf(nextPrefix) + "  ";
            } else {
                result.append("\u251c\u2500");
                nextPrefix = String.valueOf(nextPrefix) + "\u2502 ";
            }
        }
        result.append(String.valueOf(this.getValue()));
        result.append(Utils.NEW_LINE);
        int lastIndex = this.children().size() - 1;
        int i = 0;
        while (i <= lastIndex) {
            TreeNode<T> child = this.children().get(i);
            super.toString(result, nextPrefix, indent + 1, i == lastIndex);
            ++i;
        }
    }

    public TreeNode<T> clone() {
        try {
            TreeNode result = (TreeNode)super.clone();
            result.children = new ArrayList<TreeNode<T>>(this.children().size());
            for (TreeNode<T> child : this.children()) {
                result.children().add((TreeNode<T>)child.clone());
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof TreeNode) {
            TreeNode other = (TreeNode)obj;
            return Utils.eq(this.getValue(), other.getValue()) && this.children().equals(other.children());
        }
        return false;
    }

    public boolean nodeEquals(TreeNode<T> other) {
        if (other == null) {
            return false;
        }
        return Utils.eq(this.getValue(), other.getValue());
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.getValue()) ^ this.children().hashCode();
    }

    public static void main(String[] args) {
        ArrayList<TreeNode<Integer>> nodeList = new ArrayList<TreeNode<Integer>>();
        Random rnd = new Random();
        int seed = rnd.nextInt();
        System.out.println("seed: " + seed);
        rnd = new Random(seed);
        TreeNode<Integer> root = null;
        int i = 0;
        while (i < 20) {
            Integer value = rnd.nextInt(100);
            TreeNode<Integer> node = new TreeNode<Integer>(value);
            if (!nodeList.isEmpty()) {
                TreeNode parent = (TreeNode)nodeList.get(rnd.nextInt(nodeList.size()));
                parent.addChild(node);
            } else {
                root = node;
            }
            nodeList.add(node);
            ++i;
        }
        System.out.println(root);
        ArrayList<TreeNode> removedList = new ArrayList<TreeNode>();
        int i2 = 0;
        while (i2 < 5) {
            TreeNode victim = (TreeNode)nodeList.get(rnd.nextInt(nodeList.size()));
            System.out.println("Removing: " + victim.getValue() + " = " + victim);
            nodeList.remove(victim);
            removedList.add(victim);
            if (victim.getParent() != null) {
                victim.remove();
            } else {
                System.out.println("Not removed - root");
            }
            ++i2;
        }
        System.out.println("Result: " + root);
        System.out.println("Removed nodes: " + removedList);
    }
}

