/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct.skiplist;

import java.util.AbstractList;
import java.util.ArrayList;
import org.corebounce.common.struct.skiplist.ISkipNode;
import org.corebounce.common.struct.skiplist.SkipListStruct;

public class SkipListAggregateView<E>
extends AbstractList<E> {
    private final SkipListStruct<E> struct;
    private final int level;

    public SkipListAggregateView(SkipListStruct<E> struct, int level) {
        this.struct = struct;
        this.level = level;
    }

    @Override
    public E get(int index) {
        ISkipNode<E>[] path = this.struct.indexToPath(index);
        ISkipNode<E> node = path[this.level];
        this.struct.ensureAggregate(node);
        E result = node.getAggregate();
        return result;
    }

    boolean checkAggregate(ISkipNode<E> node, E aggregate) {
        ArrayList<E> items = new ArrayList<E>();
        ISkipNode<E> childNode = node.getDown();
        int i = 0;
        while (i < node.getNbElements()) {
            E item = childNode.getItem();
            items.add(item);
            childNode = childNode.getNext();
            ++i;
        }
        E checker = this.struct.getAggregator().aggregate(items);
        return aggregate.equals(checker);
    }

    @Override
    public int size() {
        return this.struct.getSize();
    }

    public int positionToIndex(long position) {
        int index = this.struct.positionToIndex(position);
        return index;
    }
}

