/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct.skiplist;

import org.corebounce.common.struct.skiplist.IHasCoverage;
import org.corebounce.common.struct.skiplist.ISkipNode;

public class SkipNode<E>
implements ISkipNode<E> {
    private int width;
    private int nbElements;
    private long srcPos = -1L;
    private long coverage;
    private SkipNode<E> prev;
    private SkipNode<E> next;
    private SkipNode<E> down;
    private E item;

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getNbElements() {
        return this.nbElements;
    }

    @Override
    public void setNbElements(int nbElements) {
        this.nbElements = nbElements;
    }

    @Override
    public long getCoverage() {
        return this.coverage;
    }

    @Override
    public void setCoverage(long coverage) {
        this.coverage = coverage;
    }

    @Override
    public void setSrcPos(long value) {
        this.srcPos = value;
    }

    @Override
    public long getSrcPos() {
        return this.srcPos;
    }

    @Override
    public ISkipNode<E> getPrev() {
        if (this.prev != null) {
            this.prev.setSrcPos(this.srcPos - this.prev.getCoverage());
        }
        return this.prev;
    }

    @Override
    public void setPrev(ISkipNode<E> prev) {
        this.prev = (SkipNode)prev;
        if (prev != null) {
            prev.setSrcPos(this.srcPos - prev.getCoverage());
        }
    }

    @Override
    public ISkipNode<E> getNext() {
        if (this.next != null) {
            this.next.setSrcPos(this.srcPos + this.coverage);
        }
        return this.next;
    }

    @Override
    public void setNext(ISkipNode<E> next) {
        this.next = (SkipNode)next;
        if (next != null) {
            next.setSrcPos(this.srcPos + this.coverage);
        }
    }

    @Override
    public SkipNode<E> getDown() {
        if (this.down != null) {
            this.down.setSrcPos(this.srcPos);
        }
        return this.down;
    }

    @Override
    public void setDown(ISkipNode<E> down) {
        this.down = (SkipNode)down;
        if (down != null) {
            down.setSrcPos(this.srcPos);
        }
    }

    @Override
    public E getItem() {
        if (this.item instanceof IHasCoverage) {
            ((IHasCoverage)this.item).setSrcPos(this.srcPos);
        }
        return this.item;
    }

    @Override
    public void setItem(E item) {
        this.item = item;
        if (item instanceof IHasCoverage) {
            this.coverage = ((IHasCoverage)item).getCoverage();
            ((IHasCoverage)item).setSrcPos(this.srcPos);
        } else {
            this.coverage = 1L;
        }
    }

    @Override
    public E getAggregate() {
        if (this.item instanceof IHasCoverage) {
            ((IHasCoverage)this.item).setSrcPos(this.srcPos);
        }
        return this.item;
    }

    @Override
    public void setAggregate(E item) {
        this.item = item;
        if (item instanceof IHasCoverage) {
            ((IHasCoverage)item).setSrcPos(this.srcPos);
        }
    }

    @Override
    public int getLevel() {
        int result = -1;
        ISkipNode<E> node = this;
        while (node.getDown() != null) {
            ++result;
            node = node.getDown();
        }
        return result;
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.hashCode());
        result.append("[");
        result.append("#elts=");
        result.append(this.nbElements);
        result.append(",width=");
        result.append(this.width);
        result.append(",next=");
        result.append(this.next == null ? "null" : Integer.valueOf(this.next.hashCode()));
        result.append(",prev=");
        result.append(this.prev == null ? "null" : Integer.valueOf(this.prev.hashCode()));
        result.append(",down=");
        result.append(this.getDown() == null ? "null" : Integer.valueOf(this.getDown().hashCode()));
        result.append("]");
        return result.toString();
    }
}

