/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import java.util.List;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.macro.Connector;
import org.corebounce.decklight.ports.InputPort;
import org.corebounce.decklight.ports.OutputPort;

public abstract class BounceletBase {
    protected final String name;
    protected final String description;
    protected final boolean isTarget;
    private SkillType skillType = SkillType.NORMAL;
    private static int autoId = 0;
    private final int id;

    public BounceletBase(String name, String description) {
        this(name, description, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BounceletBase(String name, String description, boolean isTarget) {
        Class<BounceletBase> clazz = BounceletBase.class;
        synchronized (BounceletBase.class) {
            this.id = autoId++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.name = name;
            this.description = description;
            this.isTarget = isTarget;
            return;
        }
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final int getId() {
        return this.id;
    }

    public SkillType getSkillType() {
        return this.skillType;
    }

    public void setSkillType(SkillType skillType) {
        this.skillType = skillType;
    }

    public BounceletBase newInstance() {
        try {
            return (BounceletBase)this.getClass().newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new UnsupportedOperationException("Cannot access bouncelet class");
        }
        catch (InstantiationException ex) {
            throw new UnsupportedOperationException("Cannot instanciate bouncelet class");
        }
    }

    public abstract BounceletBase[] getParts();

    public abstract void createInternalConnections(Connector var1);

    public abstract List<InputPort<?>> getInputPorts();

    public abstract List<OutputPort<?>> getOutputPorts();

    public String toString() {
        return String.valueOf(this.name) + "<" + this.id + ">";
    }
}

