/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight;

import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;

public class CycleAction
implements Comparable<CycleAction> {
    private final Bouncelet target;
    private Fraction time;

    public CycleAction(Bouncelet target, Fraction time) {
        this.target = target;
        this.time = time.clone();
    }

    public Bouncelet getTarget() {
        return this.target;
    }

    public Fraction getTime() {
        return this.time;
    }

    void setNextTime(Fraction delta) {
        this.time.add(delta);
    }

    @Override
    public int compareTo(CycleAction o) {
        int temp = this.time.compareTo(o.time);
        if (temp != 0) {
            return temp;
        }
        return this.target.getPriority().value() - o.target.getPriority().value();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CycleAction) {
            CycleAction other = (CycleAction)obj;
            return this.target.equals(other.target) && this.time == other.time;
        }
        return false;
    }

    public int hashCode() {
        return this.target.hashCode() ^ this.time.hashCode();
    }

    public String toString() {
        return this.target + " at " + this.time;
    }
}

