/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.convert;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public class C8to16
extends FilterInputStream {
    boolean signed;

    public C8to16(InputStream in, boolean signed) {
        super(in);
    }

    public static AudioFormat fixFormat(AudioFormat format) {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), 2, format.getFrameRate(), format.isBigEndian());
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * 2;
    }

    @Override
    public synchronized void mark(int readlimit) {
        super.mark(readlimit / 2);
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("8-bit reads not supported.");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        int i = result = this.in.read(b, off, (len &= 0xFFFFFFFE) / 2);
        while (--i >= 0) {
            int didx = off + i * 2;
            int sidx = off + i;
            int sample = b[sidx];
            if (sample > 0) {
                sample = 128 - sample;
            }
            b[didx + 1] = (byte)sample;
            b[didx] = (byte)sample;
        }
        return result > 0 ? result * 2 : result;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n / 2L);
    }
}

