/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.convert;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;

public abstract class ChannelMixer
extends FilterInputStream {
    int fromChannels;
    int toChannels;

    public ChannelMixer(InputStream in, int fromChannels, int toChannels) {
        super(in);
        this.fromChannels = fromChannels;
        this.toChannels = toChannels;
    }

    public AudioFormat fixFormat(AudioFormat format) {
        return new AudioFormat(format.getEncoding(), format.getSampleRate(), format.getSampleSizeInBits(), this.toChannels, format.getFrameSize() * this.toChannels / this.fromChannels, format.getFrameRate(), format.isBigEndian());
    }

    @Override
    public int read() {
        throw new UnsupportedOperationException("read() only supported for 8-bit frame size");
    }

    @Override
    public int available() throws IOException {
        return this.in.available() * this.toChannels / this.fromChannels;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.in.mark(readlimit * this.toChannels / this.fromChannels);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n * (long)this.toChannels / (long)this.fromChannels);
    }
}

