/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.convert;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import org.corebounce.decklight.audio.convert.C16BEto8;
import org.corebounce.decklight.audio.convert.C16LEto8;
import org.corebounce.decklight.audio.convert.C8to16;
import org.corebounce.decklight.audio.convert.ChannelMixer;
import org.corebounce.decklight.audio.convert.Mono2Stereo16;
import org.corebounce.decklight.audio.convert.Stereo2Mono16BE;
import org.corebounce.decklight.audio.convert.Stereo2Mono16LE;
import org.corebounce.decklight.audio.convert.Swap16;

public class PCMConverter
extends FormatConversionProvider {
    static final boolean DBG = false;
    private static final int ALL = -1;
    private static final AudioFormat[] FORMATS = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, 8, 1, 1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 1, 1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, 8, 2, 1, -1.0f, true)};
    private static final NOP[][] CONV = new NOP[][]{{new NOP(), new SWAP(), new CH1CH2(), new CH1CH2SWAP(), new C168LE(), new C168LE()}, {new SWAP(), new NOP(), new CH1CH2SWAP(), new CH1CH2(), new C168BE(), new C168BE()}, {new CH2CH1(), new CH2CH1SWAP(), new NOP(), new SWAP(), new CH2CH1C168LE(), new CH2CH1C168LE()}, {new CH2CH1SWAP(), new CH2CH1(), new SWAP(), new NOP(), new CH2CH1C168BE(), new CH2CH1C168BE()}, {new C816(), new C816(), new C816CH1CH2(), new C816CH1CH2(), new NOP(), new NOP()}, {new C816(), new C816(), new C816CH1CH2(), new C816CH1CH2(), new NOP(), new NOP()}, {new C8U16(), new C8U16(), new C8U16CH1CH2(), new C8U16CH1CH2(), new NOP(), new NOP()}, {new C8U16(), new C8U16(), new C8U16CH1CH2(), new C8U16CH1CH2(), new NOP(), new NOP()}};
    private static final AudioFormat[] EMPTY_FORMATS = new AudioFormat[0];
    private static final AudioFormat.Encoding[] ENCODINGS = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED, AudioFormat.Encoding.PCM_UNSIGNED};
    private static final AudioFormat.Encoding[] EMPTY_ENCODINGS = new AudioFormat.Encoding[0];

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return ENCODINGS;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return ENCODINGS;
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        return sourceFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED || sourceFormat.getSampleSizeInBits() == 8 ? ENCODINGS : EMPTY_ENCODINGS;
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return targetEncoding == AudioFormat.Encoding.PCM_SIGNED && (sourceFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED || sourceFormat.getSampleSizeInBits() == 8) ? FORMATS : EMPTY_FORMATS;
    }

    private int formatToIndex(AudioFormat format) {
        int i = 0;
        while (i < FORMATS.length) {
            if (format.matches(FORMATS[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (targetFormat.getSampleRate() != sourceStream.getFormat().getSampleRate()) {
            throw new IllegalArgumentException("Sample rate conversion not supported:" + sourceStream.getFormat() + "(" + this.formatToIndex(sourceStream.getFormat()) + ")" + " to " + targetFormat + "(" + this.formatToIndex(targetFormat) + ")");
        }
        try {
            return CONV[this.formatToIndex(sourceStream.getFormat())][this.formatToIndex(targetFormat)].convert(sourceStream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported conversion:" + sourceStream.getFormat() + "(" + this.formatToIndex(sourceStream.getFormat()) + ")" + " to " + targetFormat + "(" + this.formatToIndex(targetFormat) + ")");
        }
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        if (targetEncoding != AudioFormat.Encoding.PCM_SIGNED) {
            throw new IllegalArgumentException("Unsupported encoding:" + targetEncoding);
        }
        return sourceStream;
    }

    static class C168BE
    extends NOP {
        C168BE() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return new AudioInputStream(new C16BEto8(in), C16BEto8.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }

    static class C168LE
    extends NOP {
        C168LE() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return new AudioInputStream(new C16LEto8(in), C16LEto8.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }

    static class C816
    extends NOP {
        C816() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return new AudioInputStream(new C8to16(in, true), C8to16.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }

    static class C816CH1CH2
    extends NOP {
        C816 c1 = new C816();
        CH1CH2 c2 = new CH1CH2();

        C816CH1CH2() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return this.c2.convert(this.c1.convert(in));
        }
    }

    static class C8U16
    extends NOP {
        C8U16() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return new AudioInputStream(new C8to16(in, false), C8to16.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }

    static class C8U16CH1CH2
    extends NOP {
        C8U16 c1 = new C8U16();
        CH1CH2 c2 = new CH1CH2();

        C8U16CH1CH2() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return this.c2.convert(this.c1.convert(in));
        }
    }

    static class CH1CH2
    extends NOP {
        CH1CH2() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            Mono2Stereo16 stream = new Mono2Stereo16(in);
            return new AudioInputStream(stream, stream.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }

    static class CH1CH2SWAP
    extends NOP {
        CH1CH2 c1 = new CH1CH2();
        SWAP c2 = new SWAP();

        CH1CH2SWAP() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return this.c2.convert(this.c1.convert(in));
        }
    }

    static class CH2CH1
    extends NOP {
        CH2CH1() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            ChannelMixer stream = in.getFormat().isBigEndian() ? new Stereo2Mono16BE(in) : new Stereo2Mono16LE(in);
            return new AudioInputStream(stream, stream.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }

    static class CH2CH1C168BE
    extends NOP {
        CH2CH1 c1 = new CH2CH1();
        C168BE c2 = new C168BE();

        CH2CH1C168BE() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return this.c2.convert(this.c1.convert(in));
        }
    }

    static class CH2CH1C168LE
    extends NOP {
        CH2CH1 c1 = new CH2CH1();
        C168LE c2 = new C168LE();

        CH2CH1C168LE() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return this.c2.convert(this.c1.convert(in));
        }
    }

    static class CH2CH1SWAP
    extends NOP {
        CH2CH1 c1 = new CH2CH1();
        SWAP c2 = new SWAP();

        CH2CH1SWAP() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return this.c2.convert(this.c1.convert(in));
        }
    }

    static class NOP {
        NOP() {
        }

        AudioInputStream convert(AudioInputStream in) {
            return in;
        }
    }

    static class SWAP
    extends NOP {
        SWAP() {
        }

        @Override
        AudioInputStream convert(AudioInputStream in) {
            return new AudioInputStream(new Swap16(in), Swap16.fixFormat(in.getFormat()), in.getFrameLength());
        }
    }
}

