/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.convert;

import java.io.IOException;
import java.io.InputStream;
import org.corebounce.decklight.audio.convert.ChannelMixer;

public class Stereo2Mono16LE
extends ChannelMixer {
    byte[] bufcache;
    byte[] bufcachechk;

    public Stereo2Mono16LE(InputStream in) {
        super(in, 2, 1);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        len &= 0xFFFFFFFC;
        if (b != this.bufcachechk) {
            this.bufcachechk = b;
            this.bufcache = new byte[b.length * 2];
        }
        byte[] bc = this.bufcache;
        int result = this.in.read(bc, off * 2, len * 2);
        int i = off + result / 2 - 2;
        while (i >= off) {
            int didx = i;
            int sidx = i << 1;
            int sample = bc[sidx + 1] << 8 | bc[sidx] & 0xFF;
            b[didx + 1] = (byte)((sample += bc[sidx + 3] << 8 | bc[sidx + 2] & 0xFF) >> 9);
            b[didx] = (byte)(sample >> 1);
            i -= 2;
        }
        return result > 0 ? result / 2 : result;
    }
}

