/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.device;

import org.corebounce.decklight.audio.device.AudioDevice;
import org.corebounce.decklight.audio.device.AudioException;
import org.corebounce.decklight.audio.device.DummyAudioDevice;
import org.corebounce.decklight.audio.device.JavaSoundDevice;
import org.corebounce.decklight.audio.device.RtAudioDevice;
import org.corebounce.decklight.audio.device.Threading;
import org.corebounce.utils.Log;
import org.corebounce.utils.Severity;

public class AudioIO {
    private int playDeviceNum = 0;
    private int nbPlayChans = 0;
    private int recordDeviceNum = 0;
    private int nbRecordChans = 0;
    private int rate = 0;
    private int nbFrames = 0;
    private int nbBuffers = 0;
    private AudioDevice device = null;
    private boolean isInitialized = false;
    private boolean isRealtimeEnabled = true;
    private boolean isJavaSoundForced = false;
    private boolean isNoDeviceMode = false;
    private boolean autoFallbackMode = false;
    private float[] buffer = null;
    private Runnable listener;
    private static AudioIO instance = null;

    private AudioIO() {
        String nio;
        String js;
        String rt = System.getProperty("Realtime");
        if (rt != null && rt.equalsIgnoreCase("false")) {
            this.isRealtimeEnabled = false;
        }
        if ((js = System.getProperty("JavaSound")) != null && js.equalsIgnoreCase("true")) {
            this.isJavaSoundForced = true;
        }
        if ((nio = System.getProperty("NoAudioIO")) != null && nio.equalsIgnoreCase("true")) {
            this.isNoDeviceMode = true;
        }
    }

    public static synchronized AudioIO instance() {
        if (instance == null) {
            instance = new AudioIO();
        }
        return instance;
    }

    public void setAutoFallbackMode(boolean value) {
        this.autoFallbackMode = value;
    }

    public Runnable getListener() {
        return this.listener;
    }

    public void setListener(Runnable listener) {
        this.listener = listener;
    }

    public String getDeviceName() {
        if (this.device == null) {
            return null;
        }
        if (!this.isPlaying() && !this.isRecording()) {
            return null;
        }
        if (this.device instanceof DummyAudioDevice) {
            return "Dummy";
        }
        if (this.device instanceof JavaSoundDevice) {
            return "JavaSound";
        }
        if (this.device instanceof RtAudioDevice) {
            return "RtAudio";
        }
        return this.device.getClass().getSimpleName();
    }

    private AudioDevice getDevice() {
        if (!this.isJavaSoundForced && !this.isNoDeviceMode) {
            try {
                if (this.device == null) {
                    this.device = new RtAudioDevice();
                }
            }
            catch (UnsatisfiedLinkError err) {
                Log.warning("Cannot open the native low-latency audio I/O library (Pyrotechnix). Using JavaSound instead.", new Object[0]);
                if (Log.getLoggedMinSeverity().equals((Object)Severity.Debug)) {
                    err.printStackTrace();
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
        }
        if (this.device == null) {
            this.device = this.isNoDeviceMode ? new DummyAudioDevice() : new JavaSoundDevice();
        }
        this.isInitialized = false;
        return this.device;
    }

    private AudioDevice getDevice0() {
        if (this.device != null) {
            return this.device;
        }
        return this.getDevice();
    }

    public int preferredFrameSize() {
        return this.getDevice0().preferredFrameSize();
    }

    public int preferredNumberOfBuffers() {
        return this.getDevice0().preferredNumberOfBuffers();
    }

    private void flush() {
        if (this.nbPlayChans == 0 && this.nbRecordChans == 0) {
            this.nbFrames = 0;
            this.nbBuffers = 0;
            this.rate = 0;
            if (this.device != null) {
                try {
                    this.device.setup(0, 0, 0, 0, 0, 0, 0);
                }
                catch (AudioException ex) {
                    ex.printStackTrace();
                    Log.error("Failed to close audio device: {0}", ex.getMessage());
                }
                if (this.isRealtimeEnabled && this.device.prefersRealTime()) {
                    int res = Threading.leaveRealtime();
                    if (res == 0) {
                        Log.info("Leaving realtime priority", new Object[0]);
                    } else {
                        Log.warning("Failed to leave realtime priority", new Object[0]);
                    }
                } else {
                    Thread.currentThread().setPriority(5);
                }
                this.device = null;
                if (this.listener != null) {
                    this.listener.run();
                }
                System.gc();
            }
        }
    }

    public void reset() {
        String js = System.getProperty("JavaSound");
        if (js != null && js.equalsIgnoreCase("true")) {
            this.isJavaSoundForced = true;
        }
    }

    public boolean isRecording() {
        return this.nbRecordChans > 0;
    }

    public boolean isPlaying() {
        return this.nbPlayChans > 0;
    }

    public void requestPlayBack(int deviceNum, int nbChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        if (this.nbPlayChans > 0) {
            return;
        }
        if (this.nbFrames != 0 && this.nbFrames != nbFrames) {
            throw new AudioException("Capture buffer size {0} != Playback buffer size {1}", this.nbFrames, nbFrames);
        }
        if (this.nbBuffers != 0 && this.nbBuffers != nbBuffers) {
            throw new AudioException("Capture buffers {0} != Playback buffers {1}", this.nbBuffers, nbBuffers);
        }
        if (this.rate != 0 && this.rate != rate) {
            throw new AudioException("Capture rate {0} != Playback rate {1}", this.rate, rate);
        }
        this.playDeviceNum = deviceNum;
        this.nbPlayChans = nbChans;
        this.nbFrames = nbFrames;
        this.nbBuffers = nbBuffers;
        this.rate = rate;
        Log.debug("Request playback {0} {1} {2} {3}", deviceNum, nbChans, rate, nbFrames);
        if (this.getDevice() == null) {
            throw new AudioException("Cannot open audio playback {0} {1} {2}", nbChans, rate, nbFrames);
        }
    }

    public void requestCapture(int deviceNum, int nbChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        if (this.nbRecordChans > 0) {
            return;
        }
        if (this.nbFrames != 0 && this.nbFrames != nbFrames) {
            throw new AudioException("Capture buffer size {1} != Playback buffer size {0}", this.nbFrames, nbFrames);
        }
        if (this.nbBuffers != 0 && this.nbBuffers != nbBuffers) {
            throw new AudioException("Capture buffers {1} != Playback buffers {0}", this.nbBuffers, nbBuffers);
        }
        if (this.rate != 0 && this.rate != rate) {
            throw new AudioException("Capture rate {1} != Playback rate {0}", this.rate, rate);
        }
        this.recordDeviceNum = deviceNum;
        this.nbRecordChans = nbChans;
        this.nbFrames = nbFrames;
        this.nbBuffers = nbBuffers;
        this.rate = rate;
        Log.debug("Request capture {0} {1} {2} {3}", deviceNum, nbChans, rate, nbFrames);
        if (this.getDevice() == null) {
            throw new AudioException("Cannot open audio capture {0} {1} {2}", nbChans, rate, nbFrames);
        }
    }

    private void setup() throws AudioException {
        if (this.nbRecordChans != 0 || this.nbPlayChans != 0) {
            if (this.isRealtimeEnabled && this.device.prefersRealTime()) {
                int res = Threading.enterRealtime();
                if (res == 0) {
                    Log.info("Entering realtime priority", new Object[0]);
                } else {
                    Log.warning("Failed to enter realtime priority", new Object[0]);
                }
            } else {
                Thread.currentThread().setPriority(10);
            }
        }
        try {
            this.device.setup(this.recordDeviceNum, this.nbRecordChans, this.playDeviceNum, this.nbPlayChans, this.rate, this.nbFrames, this.nbBuffers);
        }
        catch (AudioException ex) {
            ex.printStackTrace();
            if (this.device.prefersRealTime()) {
                Threading.leaveRealtime();
            }
            if (this.autoFallbackMode && !(this.device instanceof JavaSoundDevice)) {
                this.device = new JavaSoundDevice();
                this.setup();
                this.isJavaSoundForced = true;
                if (this.listener != null) {
                    this.listener.run();
                }
                return;
            }
            throw ex;
        }
        this.buffer = new float[this.nbFrames * Math.max(this.nbPlayChans, this.nbRecordChans)];
        this.isInitialized = true;
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void record(float[] samples, int offset, int count) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        this.device.recordBuffer(samples, offset, count);
    }

    public void play(float[] samples, int offset, int count) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        this.device.playBuffer(samples, offset, count);
    }

    public void play(float[][] samples, int count) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        int chan = 0;
        while (chan < this.nbPlayChans) {
            int i = 0;
            while (i < count) {
                this.buffer[i * this.nbPlayChans + chan] = samples[chan][i];
                ++i;
            }
            ++chan;
        }
        this.device.playBuffer(this.buffer, 0, count * this.nbPlayChans);
    }

    public void releasePlayBack() {
        this.playDeviceNum = 0;
        this.nbPlayChans = 0;
        this.flush();
    }

    public void releaseCapture() {
        this.recordDeviceNum = 0;
        this.nbRecordChans = 0;
        this.flush();
    }
}

