/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.audio.device;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import org.corebounce.decklight.audio.device.AudioDevice;
import org.corebounce.decklight.audio.device.AudioException;

public class JavaSoundDevice
implements AudioDevice {
    private SourceDataLine playLine;
    private TargetDataLine recordLine;
    private int recordFrameSize;
    private int playFrameSize;
    private byte[] buffer;

    @Override
    public void setup(int recordDeviceNum, int nbRecordChans, int playDeviceNum, int nbPlayChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        DataLine.Info info;
        AudioFormat format;
        if (this.playLine != null) {
            this.playLine.close();
            this.playLine = null;
        }
        if (this.recordLine != null) {
            this.recordLine.close();
            this.recordLine = null;
        }
        if (recordDeviceNum != 0) {
            throw new AudioException("Record device not supported: {0}", recordDeviceNum);
        }
        if (playDeviceNum != 0) {
            throw new AudioException("Playback device not supported: {0}", playDeviceNum);
        }
        this.recordFrameSize = nbFrames * nbRecordChans;
        this.playFrameSize = nbFrames * nbPlayChans;
        this.buffer = null;
        if (nbRecordChans == 0 && nbPlayChans == 0) {
            return;
        }
        int nbChans = nbPlayChans > nbRecordChans ? nbPlayChans : nbRecordChans;
        int bufferSize = nbFrames * nbBuffers * nbChans * 2;
        if (nbPlayChans > 0) {
            try {
                format = new AudioFormat(rate, 16, nbPlayChans, true, false);
                info = new DataLine.Info(SourceDataLine.class, format, bufferSize);
                this.playLine = (SourceDataLine)AudioSystem.getLine(info);
                this.playLine.open(format, bufferSize);
                System.out.println("Playing using " + this.playLine.getClass() + "; " + nbBuffers + " * " + nbFrames + " / " + nbPlayChans + " chans");
            }
            catch (LineUnavailableException ex) {
                throw new AudioException(ex);
            }
        }
        if (nbRecordChans > 0) {
            try {
                format = new AudioFormat(rate, 16, nbRecordChans, true, false);
                info = new DataLine.Info(TargetDataLine.class, format, bufferSize);
                this.recordLine = (TargetDataLine)AudioSystem.getLine(info);
                this.recordLine.open(format, bufferSize);
                System.out.println("Recording using " + this.recordLine.getClass() + "; " + nbBuffers + " * " + nbFrames + " / " + nbRecordChans + " chans");
            }
            catch (LineUnavailableException ex) {
                throw new AudioException(ex);
            }
        }
        this.buffer = this.playFrameSize > this.recordFrameSize ? new byte[this.playFrameSize * 2] : new byte[this.recordFrameSize * 2];
    }

    @Override
    public void recordBuffer(float[] samples, int offset, int count) {
        assert (count == this.recordFrameSize);
        if (!this.recordLine.isRunning()) {
            this.recordLine.start();
        }
        this.recordLine.read(this.buffer, 0, this.recordFrameSize * 2);
        int j = 0;
        int i = offset;
        while (i < offset + count) {
            int value = (this.buffer[j + 0] & 0xFF) + (this.buffer[j + 1] << 8);
            j += 2;
            samples[i] = (float)value / 32767.0f;
            ++i;
        }
    }

    @Override
    public void playBuffer(float[] samples, int offset, int count) {
        assert (count == this.playFrameSize);
        if (!this.playLine.isRunning()) {
            this.playLine.start();
        }
        int j = 0;
        int i = offset;
        while (i < offset + count) {
            float sample = samples[i];
            int value = (double)sample < -1.0 ? Short.MIN_VALUE : ((double)sample >= 1.0 ? Short.MAX_VALUE : (int)(sample * 32767.0f));
            this.buffer[j++] = (byte)(value & 0xFF);
            this.buffer[j++] = (byte)(value >>> 8);
            ++i;
        }
        this.playLine.write(this.buffer, 0, this.playFrameSize * 2);
    }

    @Override
    public boolean prefersRealTime() {
        return false;
    }

    @Override
    public int preferredFrameSize() {
        return 4096;
    }

    @Override
    public int preferredNumberOfBuffers() {
        return 2;
    }
}

