/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio;

import org.corebounce.common.math.Cmplx;

public class CmplxAverageBuffer {
    private int size;
    private Cmplx[] values;
    private int index;
    private Cmplx sum = new Cmplx();
    private Cmplx result = new Cmplx();

    public CmplxAverageBuffer(int size) {
        this.size = size;
        this.values = Cmplx.newArray(size);
        this.index = 0;
    }

    public void push(Cmplx value) {
        this.sum.sub(this.values[this.index]);
        this.values[this.index].set(value);
        this.sum.add(value);
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
    }

    public Cmplx getAverage() {
        this.result.set(this.sum);
        this.result.mul(1.0f / (float)this.size);
        return this.result;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size == this.size) {
            return;
        }
        Cmplx[] old = this.values;
        Cmplx average = this.getAverage();
        this.size = size;
        this.values = Cmplx.newArray(size);
        int min = size < old.length ? size : old.length;
        int offset = size - min;
        int i = 0;
        while (i < min) {
            this.values[i + offset].set(old[(this.index + i) % old.length]);
            ++i;
        }
        i = 0;
        while (i < offset) {
            this.values[i].set(average);
            ++i;
        }
        this.sum.set(0.0f, 0.0f);
        i = 0;
        while (i < size) {
            this.sum.add(this.values[i]);
            ++i;
        }
        this.index = 0;
    }
}

