/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio;

import java.util.PriorityQueue;
import java.util.Random;

public class NthMaxTracker {
    private final int size;
    private int nbElements = 0;
    private PriorityQueue<Float> queue = new PriorityQueue();
    private float curRes = Float.NEGATIVE_INFINITY;

    public NthMaxTracker(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public int getNbElements() {
        return this.nbElements;
    }

    public void push(float value) {
        ++this.nbElements;
        if (value > this.curRes) {
            this.queue.add(Float.valueOf(value));
            int queueSize = this.queue.size();
            if (queueSize >= this.size) {
                if (queueSize > this.size) {
                    this.queue.remove();
                }
                this.curRes = this.queue.peek().floatValue();
            }
        }
    }

    public float getResult() {
        return this.curRes;
    }

    public static void main(String[] args) {
        Random rnd = new Random();
        NthMaxTracker tracker = new NthMaxTracker(20);
        int i = 0;
        while (i < 100) {
            float value = rnd.nextFloat();
            System.out.println(value);
            tracker.push(value);
            ++i;
        }
        System.out.println("Result: " + tracker.getResult());
    }
}

