/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.CmplxBuffer;

public class SpectrumBuffer {
    private final int nbBins;
    private int size;
    private final CmplxBuffer[] buffers;

    public SpectrumBuffer(int nbBins, int size) {
        this.nbBins = nbBins;
        this.size = size;
        this.buffers = new CmplxBuffer[nbBins];
        int i = 0;
        while (i < nbBins) {
            this.buffers[i] = new CmplxBuffer(size);
            ++i;
        }
    }

    public int getSize() {
        return this.size;
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public void push(Cmplx[] spectrum) {
        if (spectrum.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.nbBins) {
            this.buffers[i].push(spectrum[i]);
            ++i;
        }
    }

    public Cmplx peek(int bin) {
        return this.buffers[bin].peek();
    }

    public void peekInto(Cmplx[] target) {
        if (target.length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < this.nbBins) {
            target[i].set(this.buffers[i].peek());
            ++i;
        }
    }

    public void setSize(int size) {
        this.size = size;
        CmplxBuffer[] cmplxBufferArray = this.buffers;
        int n = this.buffers.length;
        int n2 = 0;
        while (n2 < n) {
            CmplxBuffer buffer = cmplxBufferArray[n2];
            buffer.setSize(size);
            ++n2;
        }
    }
}

