/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio;

import java.util.Map;
import org.corebounce.common.math.Cmplx;
import org.corebounce.utils.CacheMap;
import org.corebounce.utils.Log;

public class WorkBuffers {
    private static Map<Integer, float[]> floatBuffers = new CacheMap<Integer, float[]>();
    private static Map<Integer, Cmplx[]> cmplxBuffers = new CacheMap<Integer, Cmplx[]>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float[] getFloatBuffer(int size) {
        Map<Integer, float[]> map = floatBuffers;
        synchronized (map) {
            float[] result = floatBuffers.get(size);
            if (result == null) {
                Log.debug("Creating float[{0}] buffer", size);
                result = new float[size];
                floatBuffers.put(size, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cmplx[] getCmplxBuffer(int size) {
        Map<Integer, Cmplx[]> map = cmplxBuffers;
        synchronized (map) {
            Cmplx[] result = cmplxBuffers.get(size);
            if (result == null) {
                Log.debug("Creating Cmplx[{0}] buffer", size);
                result = Cmplx.newArray(size);
                cmplxBuffers.put(size, result);
            }
            return result;
        }
    }
}

