/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.analysis;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.ports.InFrequencies;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.OutDouble;

public class BandLevel
extends Bouncelet {
    public InFrequencies inAudio = new InFrequencies("in", "Input audio frequencies");
    public InDouble inLower = new InDouble("lower", "Band lower bound [Hz]", 20.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public InDouble inUpper = new InDouble("upper", "Band upper bound [Hz]", 150.0, 1.0, AudioConfig.MAX_FREQUENCY);
    public OutDouble outLevel = new OutDouble("level", "Band level");
    private int nbBins;
    private int lowerIndex;
    private int upperIndex;

    public BandLevel() {
        super("audio.analysis.bandlevel", "Frequency band level");
        super.setSkillType(SkillType.ADVANCED);
        this.inLower.setScaleType(ScaleType.LOG2);
        this.inUpper.setScaleType(ScaleType.LOG2);
        this.inLower.setSkillType(SkillType.SIMPLIFIED);
        this.inUpper.setSkillType(SkillType.SIMPLIFIED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        FrequenciesData audio = (FrequenciesData)this.inAudio.peek();
        if (audio.nbBins != this.nbBins || this.inLower.isModified() || this.inUpper.isModified()) {
            this.nbBins = audio.nbBins;
            float binSpace = (float)AudioConfig.getSampleRate() / (float)audio.getNbFrames();
            this.lowerIndex = (int)((Double)this.inLower.peek() / (double)binSpace);
            this.upperIndex = (int)((Double)this.inUpper.peek() / (double)binSpace + 1.0);
            if (this.upperIndex < this.lowerIndex) {
                this.upperIndex ^= this.lowerIndex;
                this.lowerIndex = this.upperIndex ^ this.lowerIndex;
                this.upperIndex ^= this.lowerIndex;
            }
            if (this.lowerIndex < 0) {
                this.lowerIndex = 0;
            } else if (this.lowerIndex >= this.nbBins) {
                this.lowerIndex = this.nbBins - 1;
            }
            if (this.upperIndex >= this.nbBins) {
                this.upperIndex = this.nbBins - 1;
            } else if (this.upperIndex < 0) {
                this.upperIndex = 0;
            }
        }
    }

    private void process() {
        FrequenciesData audio = (FrequenciesData)this.inAudio.peek();
        double result = 0.0;
        float[] data = audio.data[0];
        int i = this.lowerIndex;
        while (i < this.upperIndex) {
            result += (double)(data[i] * data[i]);
            ++i;
        }
        this.outLevel.write(Math.sqrt(result));
    }
}

