/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.analysis;

import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.ClockData;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.OutClock;

public class Beat
extends Bouncelet {
    public InDouble inLevel = new InDouble("level", "Input signal level curve");
    public InDouble inSmoothing = new InDouble("smoothing", "Reference level smoothing duration [s]", 2.5, 0.0, 20.0);
    public InDouble inThresholdMin = new InDouble("threshold.min", "Minimum tracking threshold level [dB]", -100.0, -100.0, 0.0);
    public InDouble inThresholdTrack = new InDouble("threshold.track", "Beat tracking threshold level [dB]", 6.0, 0.0, 12.0);
    public InDouble inMaxSpeed = new InDouble("maxspeed", "Maximum tracking speed [BPM]", 150.0, 60.0, 600.0);
    public OutClock outClock = new OutClock("clock", "Tracked beats clock");
    private AverageBuffer window;
    private double thresholdMin;
    private double thresholdTrack;
    private double minDuration;
    private transient double lastTime;
    private transient double lastLevel;

    public Beat() {
        super("audio.analysis.beat", "Beat tracker", true);
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inSmoothing.isModified()) {
            double cycleRate;
            double duration = (Double)this.inSmoothing.read();
            int size = (int)(duration / (cycleRate = super.getInpRate().doubleValue()));
            if (size <= 0) {
                size = 1;
            }
            if (this.window == null) {
                this.window = new AverageBuffer(size);
            } else {
                this.window.setSize(size);
            }
            System.out.println(size);
        }
        if (this.inThresholdMin.isModified()) {
            this.thresholdMin = AudioMath.dbToLevel((Double)this.inThresholdMin.read());
        }
        if (this.inThresholdTrack.isModified()) {
            this.thresholdTrack = AudioMath.dbToLevel((Double)this.inThresholdTrack.read());
        }
        if (this.inMaxSpeed.isModified()) {
            double maxSpeed = (Double)this.inMaxSpeed.read();
            if (maxSpeed < 0.01) {
                maxSpeed = 0.01;
            }
            this.minDuration = 60.0 / maxSpeed;
        }
    }

    private void process() {
        double level = (Double)this.inLevel.read();
        this.window.push(level);
        double refLevel = this.window.getAverage();
        this.outClock.setModified(false);
        if (level < this.thresholdMin) {
            return;
        }
        double curTime = super.getTime();
        if (curTime >= this.lastTime + this.minDuration && level > this.lastLevel && level >= refLevel * this.thresholdTrack) {
            System.out.println("*** Beating");
            double speed = 1.0 / (curTime - this.lastTime);
            this.outClock.write(new ClockData(curTime, speed));
            this.lastTime = curTime;
        }
        this.lastLevel = level;
    }
}

