/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.analysis;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.FrequenciesData;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutFrequencies;
import org.corebounce.decklight.bridge.ScaleType;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InBoolean;
import org.corebounce.decklight.ports.InDouble;

public class Formants
extends Bouncelet {
    public InSpectrum inSpectrum = new InSpectrum("in", "Input audio spectrum");
    public InDouble inDecayFreq = new InDouble("decay.freq", "Decay speed over frequencies", 0.1, 0.01, 100.0);
    public InBoolean inApprox = new InBoolean("fast", "Use fast approximations", true);
    public OutFrequencies outShape = new OutFrequencies("shape", "Spectral shape");
    private double freqDecay;
    private boolean fast;

    public Formants() {
        super("audio.analysis.formants", "Analyse spectral shape (formants)");
        super.setSkillType(SkillType.ADVANCED);
        this.inDecayFreq.setScaleType(ScaleType.LOG2);
    }

    public Formants(String inPortName, String inPortDescription) {
        this();
        this.inSpectrum = new InSpectrum(inPortName, inPortDescription);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.peek();
        boolean changes = this.outShape.prepare(spectrum.nbChannels, spectrum.nbBins);
        if (changes || this.inDecayFreq.isModified()) {
            double binSize = (double)AudioConfig.getSampleRate() / (double)spectrum.getNbFrames();
            this.freqDecay = 1.0 - (Double)this.inDecayFreq.read() * binSize / 15.0;
        }
        if (this.inApprox.isModified()) {
            this.fast = (Boolean)this.inApprox.read();
        }
    }

    private void process() {
        SpectrumData spectrum = (SpectrumData)this.inSpectrum.read();
        FrequenciesData frequencies = (FrequenciesData)this.outShape.get();
        int chan = 0;
        while (chan < spectrum.nbChannels) {
            Cmplx[] in = spectrum.data[chan];
            float[] shape = frequencies.data[chan];
            float srcEnergy = this.getShapeAndSrcEnergy(in, shape);
            this.applyFrequencyDecay(shape);
            this.adjustDstEnergy(shape, srcEnergy);
            ++chan;
        }
    }

    private float getShapeAndSrcEnergy(Cmplx[] in, float[] shape) {
        float srcEnergy = 0.0f;
        int i = 0;
        while (i < in.length) {
            float level = this.fast ? in[i].magApprox() : in[i].mag();
            srcEnergy += level * level;
            shape[i] = level;
            ++i;
        }
        return srcEnergy;
    }

    private void applyFrequencyDecay(float[] shape) {
        float current = shape[0];
        int i = 1;
        while (i < shape.length) {
            if (shape[i] < (current *= (float)this.freqDecay)) {
                shape[i] = current;
            } else {
                current = shape[i];
            }
            ++i;
        }
        current = shape[shape.length - 1];
        i = shape.length - 2;
        while (i >= 1) {
            if (shape[i] < (current *= (float)this.freqDecay)) {
                shape[i] = current;
            } else {
                current = shape[i];
            }
            --i;
        }
    }

    private void adjustDstEnergy(float[] out, float srcEnergy) {
        float dstEnergy = 0.0f;
        int i = 0;
        while (i < out.length) {
            dstEnergy += out[i] * out[i];
            ++i;
        }
        if (dstEnergy > 1.0E-4f) {
            float correction = (float)Math.sqrt(srcEnergy / dstEnergy) * 0.9f;
            int i2 = 0;
            while (i2 < out.length) {
                int n = i2++;
                out[n] = out[n] * correction;
            }
        }
    }
}

