/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.analysis;

import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.AudioMath;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InDouble;
import org.corebounce.decklight.ports.OutDouble;

public class Level
extends Bouncelet {
    public InAudio inAudio = new InAudio("in", "Input audio wave");
    public InDouble inThreshold = new InDouble("threshold", "Level threshold [dB]", -40.0, -100.0, 0.0);
    public InDouble inSmoothDelay = new InDouble("smoothing", "Smoothing delay [s]", 1.0, 0.0, 10.0);
    public OutDouble outLevel = new OutDouble("level", "Audio level [rms]");
    private double duration;
    private double threshold;
    private AverageBuffer history;

    public Level() {
        super("audio.analysis.level", "Analyze the audio level");
        super.setSkillType(SkillType.ADVANCED);
    }

    @Override
    public void cycle() {
        this.setup();
        this.process();
    }

    private void setup() {
        if (this.inAudio.isModified()) {
            WaveData wave = (WaveData)this.inAudio.peek();
            int samplesCount = wave.nbFrames / wave.windowing.getOverlapping().intValue();
            this.duration = (double)samplesCount / (double)AudioConfig.getSampleRate();
        }
        if (this.inSmoothDelay.isModified()) {
            int count = (int)((Double)this.inSmoothDelay.read() / this.duration);
            if (count < 1) {
                count = 1;
            }
            if (this.history == null) {
                this.history = new AverageBuffer(count);
            } else {
                this.history.setSize(count);
            }
        }
        if (this.inThreshold.isModified()) {
            this.threshold = AudioMath.dbToPowerLevel((Double)this.inThreshold.read());
        }
    }

    private void process() {
        WaveData wave = (WaveData)this.inAudio.read();
        float energy = 0.0f;
        int chan = 0;
        while (chan < wave.nbChannels) {
            energy += AudioMath.energy(wave.data[chan]);
            ++chan;
        }
        if ((double)(energy /= (float)wave.nbChannels) < this.threshold) {
            energy = 0.0f;
        }
        this.history.push(energy);
        this.outLevel.write(Double.valueOf(this.history.getAverage()));
    }
}

