/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.common.math.Fraction;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.BounceletPriority;
import org.corebounce.decklight.audio.device.AudioIO;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.SampleRate;
import org.corebounce.decklight.bouncelets.audio.ports.InPowerOf2;
import org.corebounce.decklight.bridge.SkillType;
import org.corebounce.decklight.ports.InInt;
import org.corebounce.decklight.ports.InputPort;

public class AudioConfig
extends Bouncelet {
    static final PowerOf2 DEFAULT_BLOCK_SIZE;
    static final int DEFAULT_BUFFERS;
    static final SampleRate DEFAULT_SAMPLE_RATE;
    public static final double MIN_FREQUENCY = 1.0;
    public static final double MAX_FREQUENCY;
    public InputPort<SampleRate> inSampleRate = new InputPort<SampleRate>(true, SampleRate.class, "sampleRate", "Sample rate [Hz]", DEFAULT_SAMPLE_RATE);
    public InPowerOf2 inBlockSize = new InPowerOf2(true, "blockSize", "Audio blocks size [frames]", DEFAULT_BLOCK_SIZE);
    public InInt inBuffers = new InInt(true, "buffers", "Number of buffers", DEFAULT_BUFFERS, 2, 16);
    private static SampleRate sampleRate;
    private static int intSampleRate;
    private static PowerOf2 blockSize;
    private static Fraction blockSizeFraction;
    private static int buffers;

    static {
        DEFAULT_SAMPLE_RATE = SampleRate.r44100;
        MAX_FREQUENCY = (double)DEFAULT_SAMPLE_RATE.value() / 2.0 - 1.0;
        sampleRate = DEFAULT_SAMPLE_RATE;
        intSampleRate = -1;
        AudioIO device = AudioIO.instance();
        DEFAULT_BLOCK_SIZE = PowerOf2.fromInt(device.preferredFrameSize());
        DEFAULT_BUFFERS = device.preferredNumberOfBuffers();
        blockSize = DEFAULT_BLOCK_SIZE;
        blockSizeFraction = new Fraction(blockSize.intValue()).seal();
        buffers = DEFAULT_BUFFERS;
    }

    public AudioConfig() {
        super("audio.config", "Provide common parameters for all lines", true);
        this.inSampleRate.setSkillType(SkillType.NORMAL);
        this.inBlockSize.setSkillType(SkillType.NORMAL);
        this.inBuffers.setSkillType(SkillType.NORMAL);
    }

    @Override
    public BounceletPriority getPriority() {
        return BounceletPriority.CONFIG;
    }

    @Override
    public Fraction cycleSpeed() {
        return blockSizeFraction;
    }

    @Override
    public void cycle() {
        if (this.inSampleRate.isModified()) {
            sampleRate = this.inSampleRate.read();
        }
        if (this.inBlockSize.isModified()) {
            blockSize = (PowerOf2)((Object)this.inBlockSize.read());
            blockSizeFraction = new Fraction(blockSize.intValue()).seal();
        }
        if (this.inBuffers.isModified()) {
            buffers = (Integer)this.inBuffers.read();
        }
    }

    public static int getSampleRate() {
        if (intSampleRate > 0) {
            return intSampleRate;
        }
        return sampleRate.value();
    }

    public static void setSampleRate(SampleRate value) {
        sampleRate = value;
    }

    public static void setSampleRate(int sampleRate) {
        intSampleRate = sampleRate;
    }

    public static PowerOf2 getBlockSize() {
        return blockSize;
    }

    public static void setBlockSize(PowerOf2 value) {
        blockSize = value;
        blockSizeFraction = new Fraction(blockSize.intValue()).seal();
    }

    public static int blockSize() {
        return blockSize.intValue();
    }

    public static Fraction blockSizeFraction() {
        return blockSizeFraction;
    }

    public static int getBuffers() {
        return buffers;
    }

    public static void setBuffers(int nbBuffers) {
        buffers = nbBuffers;
    }
}

