/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;

public abstract class AudioExtractSpectrumBouncelet
extends Bouncelet {
    private InSpectrum input;
    private int curChan;
    private boolean mixingDone;
    private Cmplx[][] mixed;

    public AudioExtractSpectrumBouncelet(String name, String description) {
        super(name, description);
    }

    private InSpectrum getInput() {
        if (this.input == null) {
            for (Port port : this.getInputPorts()) {
                if (!(port instanceof InSpectrum)) continue;
                this.input = (InSpectrum)port;
            }
        }
        return this.input;
    }

    protected abstract OutSpectrum getOutput1();

    protected abstract OutSpectrum getOutput2();

    @Override
    public void cycle() {
        this.mixingDone = false;
        this.setup();
        SpectrumData input = (SpectrumData)this.getInput().read();
        this.getOutput1().prepare(input);
        this.getOutput2().prepare(input);
        SpectrumData output1 = (SpectrumData)this.getOutput1().get();
        SpectrumData output2 = (SpectrumData)this.getOutput2().get();
        int chan = 0;
        while (chan < input.nbChannels) {
            this.curChan = chan;
            this.process(chan, input.data[chan], output1.data[chan], output2.data[chan]);
            ++chan;
        }
    }

    protected Cmplx[] currentSource() {
        SpectrumData spectrum = (SpectrumData)this.getInput().peek();
        if (spectrum.nbLayers == 1) {
            return spectrum.data[this.curChan];
        }
        if (!this.mixingDone) {
            if (this.mixed == null || this.mixed.length != spectrum.audioChannels() || this.mixed[0].length != spectrum.nbBins) {
                this.mixed = Cmplx.newArray(spectrum.audioChannels(), spectrum.nbBins);
            }
            spectrum.fillSumByLayer(this.mixed);
            this.mixingDone = true;
        }
        return this.mixed[this.curChan / spectrum.nbLayers];
    }

    protected void setup() {
    }

    public abstract void process(int var1, Cmplx[] var2, Cmplx[] var3, Cmplx[] var4);
}

