/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;

public abstract class AudioMonoSpectrumBouncelet
extends Bouncelet {
    private InSpectrum input;
    private OutSpectrum output;
    private boolean inPlaceCapable;
    private SpectrumData inPlaceData;
    private int curChan;
    private boolean mixingDone;
    private Cmplx[][] mixed;

    public AudioMonoSpectrumBouncelet(String name, String description) {
        super(name, description);
    }

    public AudioMonoSpectrumBouncelet(String name, String description, boolean inPlaceCapable) {
        super(name, description);
        this.inPlaceCapable = inPlaceCapable;
    }

    private InSpectrum getInput() {
        if (this.input == null) {
            for (Port port : this.getInputPorts()) {
                if (!(port instanceof InSpectrum)) continue;
                this.input = (InSpectrum)port;
            }
        }
        return this.input;
    }

    private OutSpectrum getOutput() {
        if (this.output == null) {
            for (Port port : this.getOutputPorts()) {
                if (!(port instanceof OutSpectrum)) continue;
                this.output = (OutSpectrum)port;
            }
        }
        return this.output;
    }

    @Override
    public void cycle() {
        this.mixingDone = false;
        this.setup();
        if (this.inPlaceCapable && this.getInput().canProcessInPlace()) {
            SpectrumData spectrum = (SpectrumData)this.getInput().read();
            this.curChan = 0;
            while (this.curChan < spectrum.nbChannels) {
                this.process(spectrum.data[this.curChan], spectrum.data[this.curChan]);
                ++this.curChan;
            }
            super.copyInPlace(this.getInput(), this.getOutput());
            this.inPlaceData = (SpectrumData)this.getOutput().get();
        } else {
            SpectrumData input = (SpectrumData)this.getInput().read();
            SpectrumData output = (SpectrumData)this.getOutput().get();
            if (output == this.inPlaceData) {
                this.getOutput().clear();
                this.inPlaceData = null;
            }
            this.getOutput().prepare(input);
            output = (SpectrumData)this.getOutput().get();
            this.curChan = 0;
            while (this.curChan < input.nbChannels) {
                this.process(input.data[this.curChan], output.data[this.curChan]);
                ++this.curChan;
            }
        }
    }

    protected Cmplx[] currentSource() {
        SpectrumData spectrum = (SpectrumData)this.getInput().peek();
        if (spectrum.nbLayers == 1) {
            return spectrum.data[this.curChan];
        }
        if (!this.mixingDone) {
            if (this.mixed == null || this.mixed.length != spectrum.audioChannels() || this.mixed[0].length != spectrum.nbBins) {
                this.mixed = Cmplx.newArray(spectrum.audioChannels(), spectrum.nbBins);
            }
            spectrum.fillSumByLayer(this.mixed);
            this.mixingDone = true;
        }
        return this.mixed[this.curChan / spectrum.nbLayers];
    }

    protected void setup() {
    }

    public abstract void process(Cmplx[] var1, Cmplx[] var2);
}

