/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public abstract class AudioMonoWaveBouncelet
extends Bouncelet {
    private InAudio input;
    private OutAudio output;
    private final boolean inPlaceCapable;
    private WaveData inPlaceData;

    public AudioMonoWaveBouncelet(String name, String description) {
        super(name, description);
        this.inPlaceCapable = false;
    }

    public AudioMonoWaveBouncelet(String name, String description, boolean inPlaceCapable) {
        super(name, description);
        this.inPlaceCapable = inPlaceCapable;
    }

    private InAudio getInput() {
        if (this.input == null) {
            for (Port port : this.getInputPorts()) {
                if (!(port instanceof InAudio)) continue;
                this.input = (InAudio)port;
            }
        }
        return this.input;
    }

    private OutAudio getOutput() {
        if (this.output == null) {
            for (Port port : this.getOutputPorts()) {
                if (!(port instanceof OutAudio)) continue;
                this.output = (OutAudio)port;
            }
        }
        return this.output;
    }

    @Override
    public void cycle() {
        OutAudio outAudio = this.getOutput();
        InAudio inAudio = this.getInput();
        if (this.inPlaceCapable && inAudio.canProcessInPlace()) {
            WaveData wave = (WaveData)inAudio.read();
            int chan = 0;
            while (chan < wave.nbChannels) {
                this.process(wave.data[chan], wave.data[chan]);
                ++chan;
            }
            super.copyInPlace(inAudio, outAudio);
            this.inPlaceData = (WaveData)outAudio.get();
        } else {
            WaveData input = (WaveData)inAudio.read();
            WaveData output = (WaveData)outAudio.get();
            if (output == this.inPlaceData) {
                outAudio.clear();
                this.inPlaceData = null;
            }
            outAudio.prepare(input.nbChannels, input.nbFrames, input.windowing);
            output = (WaveData)outAudio.get();
            int chan = 0;
            while (chan < input.nbChannels) {
                this.process(input.data[chan], output.data[chan]);
                ++chan;
            }
        }
    }

    public abstract void process(float[] var1, float[] var2);
}

