/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.SpectrumData;
import org.corebounce.decklight.bouncelets.audio.ports.InSpectrum;
import org.corebounce.decklight.bouncelets.audio.ports.OutSpectrum;

public abstract class AudioStateSpectrumBouncelet<E>
extends Bouncelet {
    private InSpectrum input;
    private OutSpectrum output;
    private final boolean inPlaceCapable;
    private SpectrumData inPlaceData;
    protected E[] states;

    public AudioStateSpectrumBouncelet(String name, String description) {
        super(name, description);
        this.inPlaceCapable = false;
    }

    public AudioStateSpectrumBouncelet(String name, String description, boolean inPlaceCapable) {
        super(name, description);
        this.inPlaceCapable = inPlaceCapable;
    }

    private InSpectrum getInput() {
        if (this.input == null) {
            for (Port port : this.getInputPorts()) {
                if (!(port instanceof InSpectrum)) continue;
                this.input = (InSpectrum)port;
            }
        }
        return this.input;
    }

    private OutSpectrum getOutput() {
        if (this.output == null) {
            for (Port port : this.getOutputPorts()) {
                if (!(port instanceof OutSpectrum)) continue;
                this.output = (OutSpectrum)port;
            }
        }
        return this.output;
    }

    protected abstract E[] createStates(int var1);

    @Override
    public void cycle() {
        boolean changes = this.checkForChanges();
        this.setup(changes);
        InSpectrum inSpectrum = this.getInput();
        OutSpectrum outSpectrum = this.getOutput();
        if (this.inPlaceCapable && inSpectrum.canProcessInPlace()) {
            SpectrumData spectrum = (SpectrumData)inSpectrum.read();
            if (this.states == null || changes || this.states.length != spectrum.nbChannels) {
                this.rebuildStates(spectrum);
            }
            int chan = 0;
            while (chan < spectrum.nbChannels) {
                this.process(this.states[chan], chan, spectrum.data[chan], spectrum.data[chan]);
                ++chan;
            }
            super.copyInPlace(inSpectrum, outSpectrum);
            this.inPlaceData = (SpectrumData)outSpectrum.get();
        } else {
            SpectrumData input = (SpectrumData)inSpectrum.read();
            SpectrumData output = (SpectrumData)outSpectrum.get();
            if (output == this.inPlaceData) {
                outSpectrum.clear();
                this.inPlaceData = null;
            }
            if (this.states == null || (changes |= outSpectrum.prepare(input))) {
                this.rebuildStates(input);
            }
            output = (SpectrumData)outSpectrum.get();
            int chan = 0;
            while (chan < input.nbChannels) {
                this.process(this.states[chan], chan, input.data[chan], output.data[chan]);
                ++chan;
            }
        }
    }

    private void rebuildStates(SpectrumData spectrum) {
        this.states = this.createStates(spectrum.nbChannels);
    }

    public abstract boolean checkForChanges();

    public void setup(boolean changes) {
    }

    public abstract void process(E var1, int var2, Cmplx[] var3, Cmplx[] var4);
}

