/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public abstract class AudioStateWaveBouncelet<E>
extends Bouncelet {
    private InAudio input;
    private OutAudio output;
    private final boolean inPlaceCapable;
    private WaveData inPlaceData;
    protected E[] states;

    public AudioStateWaveBouncelet(String name, String description) {
        super(name, description);
        this.inPlaceCapable = false;
    }

    public AudioStateWaveBouncelet(String name, String description, boolean inPlaceCapable) {
        super(name, description);
        this.inPlaceCapable = inPlaceCapable;
    }

    protected InAudio getInput() {
        if (this.input == null) {
            for (Port port : this.getInputPorts()) {
                if (!(port instanceof InAudio)) continue;
                this.input = (InAudio)port;
            }
        }
        return this.input;
    }

    protected OutAudio getOutput() {
        if (this.output == null) {
            for (Port port : this.getOutputPorts()) {
                if (!(port instanceof OutAudio)) continue;
                this.output = (OutAudio)port;
            }
        }
        return this.output;
    }

    protected abstract E[] createStates(int var1);

    @Override
    public void cycle() {
        boolean changes = this.checkForChanges();
        this.setup(changes);
        InAudio inAudio = this.getInput();
        OutAudio outAudio = this.getOutput();
        if (this.inPlaceCapable && inAudio.canProcessInPlace()) {
            WaveData wave = (WaveData)inAudio.read();
            if (this.states == null || changes || this.states.length != wave.nbChannels) {
                this.rebuildStates(wave);
            }
            int chan = 0;
            while (chan < wave.nbChannels) {
                this.process(this.states[chan], wave.data[chan], wave.data[chan]);
                ++chan;
            }
            super.copyInPlace(inAudio, outAudio);
            this.inPlaceData = (WaveData)outAudio.get();
        } else {
            WaveData input = (WaveData)inAudio.read();
            WaveData output = (WaveData)outAudio.get();
            if (output == this.inPlaceData) {
                outAudio.clear();
                this.inPlaceData = null;
            }
            if (this.states == null || (changes |= outAudio.prepare(input.nbChannels, input.nbFrames, input.windowing))) {
                this.rebuildStates(input);
            }
            output = (WaveData)outAudio.get();
            int chan = 0;
            while (chan < input.nbChannels) {
                this.process(this.states[chan], input.data[chan], output.data[chan]);
                ++chan;
            }
        }
    }

    private void rebuildStates(WaveData wave) {
        this.states = this.createStates(wave.nbChannels);
    }

    public abstract boolean checkForChanges();

    public void setup(boolean changes) {
    }

    public abstract void process(E var1, float[] var2, float[] var3);
}

