/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import org.corebounce.decklight.Bouncelet;
import org.corebounce.decklight.Port;
import org.corebounce.decklight.bouncelets.audio.base.WaveData;
import org.corebounce.decklight.bouncelets.audio.ports.InAudio;
import org.corebounce.decklight.bouncelets.audio.ports.OutAudio;

public abstract class AudioWaveBouncelet
extends Bouncelet {
    private InAudio input;
    private OutAudio output;

    public AudioWaveBouncelet(String name, String description, boolean isTarget) {
        super(name, description, isTarget);
    }

    public AudioWaveBouncelet(String name, String description) {
        super(name, description);
    }

    private InAudio getInput() {
        if (this.input == null) {
            for (Port port : this.getInputPorts()) {
                if (!(port instanceof InAudio)) continue;
                this.input = (InAudio)port;
            }
        }
        return this.input;
    }

    private OutAudio getOutput() {
        if (this.output == null) {
            for (Port port : this.getOutputPorts()) {
                if (!(port instanceof OutAudio)) continue;
                this.output = (OutAudio)port;
            }
        }
        return this.output;
    }

    @Override
    public void cycle() {
        WaveData input = (WaveData)this.getInput().read();
        this.getOutput().prepare(input.nbChannels, input.nbFrames, input.windowing);
        WaveData output = (WaveData)this.getOutput().get();
        this.process(input.data, output.data);
    }

    public abstract void process(float[][] var1, float[][] var2);
}

