/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import java.io.Serializable;
import org.corebounce.common.math.Cmplx;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.bouncelets.audio.convert.format.asharp.HqxMode;
import org.corebounce.decklight.ports.PublicCloneable;
import org.corebounce.utils.Log;

public class SpectrumData
implements PublicCloneable<SpectrumData>,
Serializable {
    private static final long serialVersionUID = -2753926821762913589L;
    public Cmplx[][] data;
    public int nbChannels;
    public int nbLayers = 1;
    public HqxMode hqxMode = null;
    public int nbBins;
    public WindowInfo windowing;

    public SpectrumData(Cmplx[][] data, WindowInfo windowing) {
        Log.debug("Creating SpectrumData", new Object[0]);
        int i = 0;
        while (i < data.length) {
            assert ((data[i].length - 1) * 2 == windowing.windowLength());
            ++i;
        }
        this.data = data;
        this.nbChannels = data.length;
        this.nbBins = data[0].length;
        this.windowing = windowing;
    }

    public SpectrumData(int nbChannels, int nbBins) {
        this(nbChannels, nbBins, null);
    }

    public SpectrumData(int nbChannels, int nbBins, WindowInfo windowing) {
        Log.debug("Creating SpectrumData, chans={0}, bins={1}", nbChannels, nbBins);
        this.data = new Cmplx[nbChannels][];
        int i = 0;
        while (i < nbChannels) {
            this.data[i] = Cmplx.newArray(nbBins);
            ++i;
        }
        this.nbChannels = nbChannels;
        this.nbBins = nbBins;
        if (windowing == null) {
            int nbFrames = (nbBins - 1) * 2;
            float[] window = WindowFactory.getWindow(WindowType.Rectangular, nbFrames);
            windowing = new WindowInfo(window, PowerOf2.p1);
        }
        this.windowing = windowing;
    }

    public int getNbFrames() {
        return (this.nbBins - 1) * 2 / this.windowing.getZeroPadding().intValue();
    }

    public int getShiftSize() {
        return this.getNbFrames() / this.windowing.getOverlapping().intValue();
    }

    public int audioChannels() {
        if (this.nbChannels % this.nbLayers != 0) {
            throw new IllegalStateException();
        }
        return this.nbChannels / this.nbLayers;
    }

    public double getRealDuration() {
        return (double)this.getNbFrames() / ((double)AudioConfig.getSampleRate() * (double)this.windowing.getOverlapping().intValue() * (double)this.windowing.getZeroPadding().intValue());
    }

    public double getProcessingDuration() {
        return (double)this.getNbFrames() / (double)AudioConfig.getSampleRate();
    }

    public void fillSum(Cmplx[] target) {
        if (target.length != this.nbBins) {
            throw new IllegalArgumentException("Invalid array size");
        }
        Cmplx[] data0 = this.data[0];
        int i = 0;
        while (i < this.nbBins) {
            target[i].set(data0[i]);
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChannels) {
            Cmplx[] datac = this.data[chan];
            int i2 = 0;
            while (i2 < this.nbBins) {
                target[i2].add(datac[i2]);
                ++i2;
            }
            ++chan;
        }
    }

    public void fillSumByLayer(Cmplx[][] target) {
        if (target.length != this.audioChannels() || target[0].length != this.nbBins) {
            throw new IllegalArgumentException();
        }
        int c = 0;
        while (c < this.audioChannels()) {
            int d = c * this.nbLayers;
            Cmplx[] src = this.data[d];
            Cmplx[] dst = target[c];
            int i = 0;
            while (i < this.nbBins) {
                dst[i].set(src[i]);
                ++i;
            }
            int l = 1;
            while (l < this.nbLayers) {
                src = this.data[d + l];
                dst = target[c];
                int i2 = 0;
                while (i2 < this.nbBins) {
                    dst[i2].add(src[i2]);
                    ++i2;
                }
                ++l;
            }
            ++c;
        }
    }

    @Override
    public SpectrumData clone() {
        try {
            SpectrumData result = (SpectrumData)super.clone();
            result.data = Cmplx.newArray(this.nbChannels, this.nbBins);
            int c = 0;
            while (c < this.nbChannels) {
                int b = 0;
                while (b < this.nbBins) {
                    result.data[c][b].set(this.data[c][b]);
                    ++b;
                }
                ++c;
            }
            result.nbLayers = this.nbLayers;
            result.hqxMode = this.hqxMode;
            result.windowing = this.windowing.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(SpectrumData clone) {
        if (clone.nbChannels != this.nbChannels || clone.nbBins != this.nbBins) {
            clone.nbChannels = this.nbChannels;
            clone.nbBins = this.nbBins;
            clone.nbLayers = this.nbLayers;
            clone.hqxMode = this.hqxMode;
            clone.data = Cmplx.newArray(this.nbChannels, this.nbBins);
        }
        int c = 0;
        while (c < this.nbChannels) {
            int b = 0;
            while (b < this.nbBins) {
                clone.data[c][b].set(this.data[c][b]);
                ++b;
            }
            ++c;
        }
        if (clone.windowing == null) {
            clone.windowing = this.windowing.clone();
        } else {
            this.windowing.copyTo(clone.windowing);
        }
    }
}

