/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import java.io.Serializable;
import org.corebounce.decklight.bouncelets.audio.base.AudioConfig;
import org.corebounce.decklight.bouncelets.audio.base.PowerOf2;
import org.corebounce.decklight.bouncelets.audio.base.WindowFactory;
import org.corebounce.decklight.bouncelets.audio.base.WindowInfo;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.decklight.ports.PublicCloneable;
import org.corebounce.utils.Log;

public class WaveData
implements PublicCloneable<WaveData>,
Serializable {
    private static final long serialVersionUID = -5347732110027167774L;
    public float[][] data;
    public int nbChannels;
    public int nbFrames;
    public WindowInfo windowing;

    public WaveData(float[][] data, int nbChannels, WindowInfo windowing) {
        Log.debug("Creating WaveData", new Object[0]);
        assert (nbChannels == data.length);
        int i = 0;
        while (i < data.length) {
            assert (data[i].length == windowing.windowLength());
            ++i;
        }
        this.data = data;
        this.nbChannels = nbChannels;
        this.nbFrames = data.length;
        this.windowing = windowing;
    }

    private static float[] rectangular(int size) {
        return WindowFactory.getWindow(WindowType.Rectangular, size);
    }

    private static WindowInfo noWindowing(int size) {
        return new WindowInfo(WaveData.rectangular(size), PowerOf2.p1);
    }

    public WaveData(int nbChannels, int nbFrames) {
        this(nbChannels, nbFrames, WaveData.noWindowing(nbFrames));
    }

    public WaveData(int nbChannels, int nbFrames, WindowInfo windowing) {
        Log.debug("Creating WaveData; chans={0}, frames={1}", nbChannels, nbFrames);
        this.data = new float[nbChannels][nbFrames];
        this.nbChannels = nbChannels;
        this.nbFrames = nbFrames;
        this.windowing = windowing;
        if (windowing == null) {
            this.windowing = WaveData.noWindowing(nbFrames);
        }
    }

    public void fillSum(float[] target, boolean normalize) {
        if (target.length != this.nbFrames) {
            throw new IllegalArgumentException("Invalid array size");
        }
        float correction = normalize ? 1.0f / (float)this.nbChannels : 1.0f;
        float[] data0 = this.data[0];
        int i = 0;
        while (i < this.nbFrames) {
            target[i] = data0[i] * correction;
            ++i;
        }
        int chan = 1;
        while (chan < this.nbChannels) {
            float[] datac = this.data[chan];
            int i2 = 0;
            while (i2 < this.nbFrames) {
                int n = i2;
                target[n] = target[n] + datac[i2] * correction;
                ++i2;
            }
            ++chan;
        }
    }

    public int getNbBins(PowerOf2 zeroPadding) {
        return this.nbFrames * zeroPadding.intValue() / 2 + 1;
    }

    public double getRealDuration() {
        return (double)this.nbFrames / ((double)AudioConfig.getSampleRate() * (double)this.windowing.getOverlapping().intValue() * (double)this.windowing.getZeroPadding().intValue());
    }

    public double getProcessingDuration() {
        return (double)this.nbFrames / (double)AudioConfig.getSampleRate();
    }

    @Override
    public WaveData clone() {
        try {
            WaveData result = (WaveData)super.clone();
            result.data = new float[this.nbChannels][this.nbFrames];
            int i = 0;
            while (i < this.nbChannels) {
                System.arraycopy(this.data[i], 0, result.data[i], 0, this.nbFrames);
                ++i;
            }
            result.windowing = this.windowing.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    @Override
    public void copyTo(WaveData clone) {
        if (clone.nbChannels != this.nbChannels || clone.nbFrames != this.nbFrames) {
            clone.nbChannels = this.nbChannels;
            clone.nbFrames = this.nbFrames;
            clone.data = new float[this.nbChannels][this.nbFrames];
        }
        int i = 0;
        while (i < this.nbChannels) {
            System.arraycopy(this.data[i], 0, clone.data[i], 0, this.nbFrames);
            ++i;
        }
        if (clone.windowing == null) {
            clone.windowing = this.windowing.clone();
        } else {
            this.windowing.copyTo(clone.windowing);
        }
    }
}

