/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.decklight.bouncelets.audio.base;

import java.util.Arrays;
import java.util.Map;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.decklight.bouncelets.audio.base.WindowType;
import org.corebounce.utils.CacheMap;
import org.corebounce.utils.Log;

public class WindowFactory {
    private static Map<WindowDefinition, float[]> windows = new CacheMap<WindowDefinition, float[]>();

    public static float[] getWindow(WindowType type, int size) {
        WindowDefinition def = new WindowDefinition(type, size);
        float[] result = windows.get(def);
        if (result == null) {
            Log.debug("Building window type {0}, size {1}", new Object[]{type, size});
            result = WindowFactory.createWindow(type, size);
            windows.put(def, result);
        }
        return result;
    }

    private static float[] createWindow(WindowType type, int size) {
        float[] result = new float[size];
        switch (type) {
            case Rectangular: {
                int i = 0;
                while (i < size) {
                    result[i] = 1.0f;
                    ++i;
                }
                break;
            }
            case Triangular: {
                Windows.fillTriangularWindow(result, size);
                break;
            }
            case Hann: {
                Windows.fillWindow(result, size, Windows.HannCoefs);
                break;
            }
            case Hamming: {
                Windows.fillWindow(result, size, Windows.HammingCoefs);
                break;
            }
            case Blackmann: {
                Windows.fillWindow(result, size, Windows.BlackmannCoefs);
                break;
            }
            case Nutall: {
                Windows.fillWindow(result, size, Windows.NutallCoefs);
                break;
            }
            case Gaussian: {
                Windows.fillGaussianWindow(result, size);
                break;
            }
            case FlatTop: {
                Windows.fillWindow(result, size, Windows.FlatTopCoefs);
                break;
            }
            case Kaiser40: {
                Windows.fillKaiserWindow(result, size, 40.0f);
                break;
            }
            case Kaiser50: {
                Windows.fillKaiserWindow(result, size, 50.0f);
                break;
            }
            case Kaiser60: {
                Windows.fillKaiserWindow(result, size, 60.0f);
                break;
            }
            case Kaiser80: {
                Windows.fillKaiserWindow(result, size, 80.0f);
                break;
            }
            case Kaiser100: {
                Windows.fillKaiserWindow(result, size, 100.0f);
                break;
            }
            case Chebyshev80: {
                Windows.fillChebyshevWindow(result, 80.0f, new BooFFT(size));
                break;
            }
            case Chebyshev100: {
                Windows.fillChebyshevWindow(result, 100.0f, new BooFFT(size));
                break;
            }
            case HannShrink2: {
                Windows.fillShrunkWindow(result, Windows.HannCoefs, 2.0f);
                break;
            }
            case HannShrink4: {
                Windows.fillShrunkWindow(result, Windows.HannCoefs, 4.0f);
                break;
            }
            case HannShrink16: {
                Windows.fillShrunkWindow(result, Windows.HannCoefs, 16.0f);
                break;
            }
            case HannShrink15_16: {
                Windows.fillShrunkWindow(result, Windows.HannCoefs, 1.0666667f);
                break;
            }
            case HannLeft8: {
                float[] temp = new float[size / 8];
                Windows.fillWindow(temp, temp.length, Windows.HannCoefs);
                Windows.fillWindow(result, size, Windows.HannCoefs);
                System.arraycopy(temp, temp.length / 2, result, size / 2, temp.length / 2);
                Arrays.fill(result, size / 2 + temp.length / 2, size, 0.0f);
                break;
            }
            case HannRight8: {
                float[] temp = new float[size / 8];
                Windows.fillWindow(temp, temp.length, Windows.HannCoefs);
                Windows.fillWindow(result, size, Windows.HannCoefs);
                System.arraycopy(temp, 0, result, size / 2 - temp.length / 2, temp.length / 2);
                Arrays.fill(result, 0, size / 2 - temp.length / 2, 0.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Window type not implemented: " + (Object)((Object)type));
            }
        }
        return result;
    }

    private static class WindowDefinition {
        public final WindowType type;
        public final int size;

        public WindowDefinition(WindowType type, int size) {
            this.type = type;
            this.size = size;
        }

        public boolean equals(Object obj) {
            if (obj instanceof WindowDefinition) {
                WindowDefinition other = (WindowDefinition)obj;
                return this.type.equals((Object)other.type) && this.size == other.size;
            }
            return false;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.size;
        }
    }
}

